'use client';

import { ReactNode } from 'react';
import { useSession } from 'next-auth/react';
import FreelancerSidebar from '@/components/freelancer/FreelancerSidebar';
import { useUserRatings } from '@/hooks/useUserRatings';

interface FreelancerLayoutProps {
  children: ReactNode;
  locale: string;
  userProfile?: {
    name: string;
    profileImage: string;
    rating: number;
    reviewCount: number;
  };
  unreadMessagesCount?: number;
}

const FreelancerLayout: React.FC<FreelancerLayoutProps> = ({
  children,
  locale,
  userProfile,
  unreadMessagesCount = 0
}) => {
  const { data: session } = useSession();
  const { averageRating, totalReviews, isLoading } = useUserRatings();

  // Default profile data with dynamic ratings
  const defaultProfile = {
    name: session?.user?.name || userProfile?.name || 'Freelancer',
    profileImage: session?.user?.image || userProfile?.profileImage || '/assets/image/profile03.png',
    rating: userProfile?.rating || averageRating,
    reviewCount: userProfile?.reviewCount || totalReviews
  };



  return (
    <section className="profile-wrapper client-wrapper py-60 test3">
      <div className="container">
        <div className="row">
          <FreelancerSidebar 
            locale={locale}
            userProfile={defaultProfile}
            unreadMessagesCount={unreadMessagesCount}
          />
          
          <div className="col-12 col-md-8 col-xl-9">
            {children}
          </div>
        </div>
      </div>
    </section>
  );
};

export default FreelancerLayout;