export const htmlToText = (html: any) => {
    if (!html) return '';

    const tempDiv = document.createElement('div');
    tempDiv.innerHTML = html;
    const text = tempDiv.textContent || tempDiv.innerText || '';
    return text.replace(/\s+/g, ' ').trim();
};

export function maskName(name: string): string {
  if (!name) return "User";
      const visiblePart = name.slice(0, 3);
      const maskedPart = "x".repeat(Math.max(name.length - 3, 3)); // at least 3 x's
      return visiblePart + maskedPart;
  }

export function maskEmail(email: string): string {
      if (!email || !email.includes("@")) return email;
      const [localPart, domain] = email.split("@");
      if (localPart.length <= 3) {
        // If shorter than 3 chars, just add x's
        return localPart + "x".repeat(3) + "@" + domain;
      }
      const visible = localPart.slice(0, 3);
      const masked = "x".repeat(localPart.length - 3);
      return `${visible}${masked}@${domain}`;
}


export function maskMobileNumber(number: string): string {
  if (!number) return "";

  const digits = number.replace(/\D/g, ""); // keep only digits
  if (digits.length <= 4) return digits; // don't mask if 4 or fewer digits

  const visible = digits.slice(-4); // last 4 digits
  const masked = "x".repeat(digits.length - 4);

  return `${masked}${visible}`;
}