import { PrismaClient } from '@prisma/client';

const prisma = new PrismaClient();

export const categoriesData = [
  {
    name_en: 'Architecture / Project Management',
    name_fr: 'Architecture / Maîtrise d\'œuvre',
    name_de: 'Architektur / Projektmanagement',
    name_it: 'Architettura / Gestione Progetti',
    name_pt: 'Arquitetura / Gestão de Projetos',
    name_es: 'Arquitectura / Gestión de Proyectos',
    slug: 'architecture-project-management',
    description_en: 'Architecture / Project Management',
    description_fr: 'Architecture / Maîtrise d\'œuvre',
    description_de: 'Architektur / Projektmanagement',
    description_it: 'Architettura / Gestione Progetti',
    description_pt: 'Arquitetura / Gestão de Projetos',
    description_es: 'Arquitectura / Gestión de Proyectos',
    icon: 'category_1.svg',
    isActive: true
  },
  {
    name_en: 'Masonry',
    name_fr: 'Maçonnerie',
    name_de: 'Maurerarbeiten',
    name_it: 'Muratura',
    name_pt: 'Alvenaria',
    name_es: 'Albañilería',
    slug: 'masonry',
    description_en: 'Masonry',
    description_fr: 'Maçonnerie',
    description_de: 'Maurerarbeiten',
    description_it: 'Muratura',
    description_pt: 'Alvenaria',
    description_es: 'Albañilería',
    icon: 'category_2.svg',
    isActive: true
  },
  {
    name_en: 'Carpentry',
    name_fr: 'Charpente',
    name_de: 'Zimmerei',
    name_it: 'Falegnameria',
    name_pt: 'Carpintaria',
    name_es: 'Carpintería',
    slug: 'carpentry',
    description_en: 'Carpentry',
    description_fr: 'Charpente',
    description_de: 'Zimmerei',
    description_it: 'Falegnameria',
    description_pt: 'Carpintaria',
    description_es: 'Carpintería',
    icon: 'category_3.svg',
    isActive: true
  },
  {
    name_en: 'Roofing',
    name_fr: 'Couverture / Toiture',
    name_de: 'Dachdeckerarbeiten',
    name_it: 'Coperture',
    name_pt: 'Telhados',
    name_es: 'Techados',
    slug: 'roofing',
    description_en: 'Roofing',
    description_fr: 'Couverture / Toiture',
    description_de: 'Dachdeckerarbeiten',
    description_it: 'Coperture',
    description_pt: 'Telhados',
    description_es: 'Techados',
    icon: 'category_4.svg',
    isActive: true
  },
  {
    name_en: 'Sanitation',
    name_fr: 'Assainissement',
    name_de: 'Sanitärinstallationen',
    name_it: 'Igiene',
    name_pt: 'Saneamento',
    name_es: 'Saneamiento',
    slug: 'sanitation',
    description_en: 'Sanitation',
    description_fr: 'Assainissement',
    description_de: 'Sanitärinstallationen',
    description_it: 'Igiene',
    description_pt: 'Saneamento',
    description_es: 'Saneamiento',
    icon: 'category_5.svg',
    isActive: true
  },
  {
    name_en: 'Metal Construction',
    name_fr: 'Construction métallique',
    name_de: 'Metallbau',
    name_it: 'Costruzioni Metalliche',
    name_pt: 'Construção Metálica',
    name_es: 'Construcción Metálica',
    slug: 'metal-construction',
    description_en: 'Metal Construction',
    description_fr: 'Construction métallique',
    description_de: 'Metallbau',
    description_it: 'Costruzioni Metalliche',
    description_pt: 'Construção Metálica',
    description_es: 'Construcción Metálica',
    icon: 'category_6.svg',
    isActive: true
  },
  {
    name_en: 'Waterproofing',
    name_fr: 'Étanchéité',
    name_de: 'Abdichtung',
    name_it: 'Impermeabilizzazione',
    name_pt: 'Impermeabilização',
    name_es: 'Impermeabilización',
    slug: 'waterproofing',
    description_en: 'Waterproofing',
    description_fr: 'Étanchéité',
    description_de: 'Abdichtung',
    description_it: 'Impermeabilizzazione',
    description_pt: 'Impermeabilização',
    description_es: 'Impermeabilización',
    icon: 'category_7.svg',
    isActive: true
  },
  {
    name_en: 'Scaffolding',
    name_fr: 'Échafaudage',
    name_de: 'Gerüstbau',
    name_it: 'Ponteggi',
    name_pt: 'Andaimes',
    name_es: 'Andamiaje',
    slug: 'scaffolding',
    description_en: 'Scaffolding',
    description_fr: 'Échafaudage',
    description_de: 'Gerüstbau',
    description_it: 'Ponteggi',
    description_pt: 'Andaimes',
    description_es: 'Andamiaje',
    icon: 'category_8.svg',
    isActive: true
  },
  {
    name_en: 'Plastering',
    name_fr: 'Plâtrerie',
    name_de: 'Verputzen',
    name_it: 'Intonacatura',
    name_pt: 'Reboco',
    name_es: 'Enlucido',
    slug: 'plastering',
    description_en: 'Plastering',
    description_fr: 'Plâtrerie',
    description_de: 'Verputzen',
    description_it: 'Intonacatura',
    description_pt: 'Reboco',
    description_es: 'Enlucido',
    icon: 'category_9.svg',
    isActive: true
  },
  {
    name_en: 'Tiling',
    name_fr: 'Carrelage',
    name_de: 'Fliesenverlegung',
    name_it: 'Piastrellatura',
    name_pt: 'Azulejos',
    name_es: 'Alicatado',
    slug: 'tiling',
    description_en: 'Tiling',
    description_fr: 'Carrelage',
    description_de: 'Fliesenverlegung',
    description_it: 'Piastrellatura',
    description_pt: 'Azulejos',
    description_es: 'Alicatado',
    icon: 'category_10.svg',
    isActive: true
  },
  {
    name_en: 'Flooring (parquet, linoleum, resilient flooring)',
    name_fr: 'Revêtements de sols (parquet, lino, sols souples)',
    name_de: 'Bodenbeläge (Parkett, Linoleum, elastische Bodenbeläge)',
    name_it: 'Pavimentazione (parquet, linoleum, pavimenti resilienti)',
    name_pt: 'Pavimentos (parquet, linóleo, pavimentos resilientes)',
    name_es: 'Suelos (parquet, linóleo, suelos flexibles)',
    slug: 'flooring',
    description_en: 'Flooring (parquet, linoleum, resilient flooring)',
    description_fr: 'Revêtements de sols (parquet, lino, sols souples)',
    description_de: 'Bodenbeläge (Parkett, Linoleum, elastische Bodenbeläge)',
    description_it: 'Pavimentazione (parquet, linoleum, pavimenti resilienti)',
    description_pt: 'Pavimentos (parquet, linóleo, pavimentos resilientes)',
    description_es: 'Suelos (parquet, linóleo, suelos flexibles)',
    icon: 'category_11.svg',
    isActive: true
  },
  {
    name_en: 'Painting',
    name_fr: 'Peinture',
    name_de: 'Malerarbeiten',
    name_it: 'Tinteggiatura',
    name_pt: 'Pintura',
    name_es: 'Pintura',
    slug: 'painting',
    description_en: 'Painting',
    description_fr: 'Peinture',
    description_de: 'Malerarbeiten',
    description_it: 'Tinteggiatura',
    description_pt: 'Pintura',
    description_es: 'Pintura',
    icon: 'category_12.svg',
    isActive: true
  },
  {
    name_en: 'Wallpapering',
    name_fr: 'Tapisserie / papier peint',
    name_de: 'Tapezieren',
    name_it: 'Tappezzeria',
    name_pt: 'Papel de Parede',
    name_es: 'Papel pintado',
    slug: 'wallpapering',
    description_en: 'Wallpapering',
    description_fr: 'Tapisserie / papier peint',
    description_de: 'Tapezieren',
    description_it: 'Tappezzeria',
    description_pt: 'Papel de Parede',
    description_es: 'Papel pintado',
    icon: 'category_13.svg',
    isActive: true
  },
  {
    name_en: 'Cabinetmaking / Interior Joinery',
    name_fr: 'Ébénisterie / Menuiserie intérieure',
    name_de: 'Schreinerarbeiten / Innenausbau',
    name_it: 'Ebanisteria / Falegnameria per Interni',
    name_pt: 'Marcenaria / Carpintaria de Interiores',
    name_es: 'Ebanistería / Carpintería de Interiores',
    slug: 'cabinetmaking-interior-joinery',
    description_en: 'Cabinetmaking / Interior Joinery',
    description_fr: 'Ébénisterie / Menuiserie intérieure',
    description_de: 'Schreinerarbeiten / Innenausbau',
    description_it: 'Ebanisteria / Falegnameria per Interni',
    description_pt: 'Marcenaria / Carpintaria de Interiores',
    description_es: 'Ebanistería / Carpintería de Interiores',
    icon: 'category_14.svg',
    isActive: true
  },
  {
    name_en: 'Interior Decoration',
    name_fr: 'Décoration d\'intérieur',
    name_de: 'Innenausbau',
    name_it: 'Decorazione d\'Interni',
    name_pt: 'Decoração de Interiores',
    name_es: 'Decoración de Interiores',
    slug: 'interior-decoration',
    description_en: 'Interior Decoration',
    description_fr: 'Décoration d\'intérieur',
    description_de: 'Innenausbau',
    description_it: 'Decorazione d\'Interni',
    description_pt: 'Decoração de Interiores',
    description_es: 'Decoración de Interiores',
    icon: 'category_15.svg',
    isActive: true
  },
  {
    name_en: 'Electricity',
    name_fr: 'Électricité',
    name_de: 'Elektroinstallationen',
    name_it: 'Elettricità',
    name_pt: 'Eletricidade',
    name_es: 'Electricidad',
    slug: 'electricity',
    description_en: 'Electricity',
    description_fr: 'Électricité',
    description_de: 'Elektroinstallationen',
    description_it: 'Elettricità',
    description_pt: 'Eletricidade',
    description_es: 'Electricidad',
    icon: 'category_16.svg',
    isActive: true
  },
  {
    name_en: 'Electronics / Multimedia',
    name_fr: 'Électronique / multimédia',
    name_de: 'Elektrotechnik / Multimedia',
    name_it: 'Elettronica / Multimedia',
    name_pt: 'Eletrónica / Multimédia',
    name_es: 'Electrónica / Multimedia',
    slug: 'electronics-multimedia',
    description_en: 'Electronics / Multimedia',
    description_fr: 'Électronique / multimédia',
    description_de: 'Elektrotechnik / Multimedia',
    description_it: 'Elettronica / Multimedia',
    description_pt: 'Eletrónica / Multimédia',
    description_es: 'Electrónica / Multimedia',
    icon: 'category_17.svg',
    isActive: true
  },
  {
    name_en: 'Heating',
    name_fr: 'Chauffage',
    name_de: 'Heizung',
    name_it: 'Riscaldamento',
    name_pt: 'Aquecimento',
    name_es: 'Calefacción',
    slug: 'heating',
    description_en: 'Heating',
    description_fr: 'Chauffage',
    description_de: 'Heizung',
    description_it: 'Riscaldamento',
    description_pt: 'Aquecimento',
    description_es: 'Calefacción',
    icon: 'category_18.svg',
    isActive: true
  },
  {
    name_en: 'Air Conditioning',
    name_fr: 'Climatisation',
    name_de: 'Klimaanlage',
    name_it: 'Aria Condizionata',
    name_pt: 'Ar Condicionado',
    name_es: 'Aire Acondicionado',
    slug: 'air-conditioning',
    description_en: 'Air Conditioning',
    description_fr: 'Climatisation',
    description_de: 'Klimaanlage',
    description_it: 'Aria Condizionata',
    description_pt: 'Ar Condicionado',
    description_es: 'Aire Acondicionado',
    icon: 'category_19.svg',
    isActive: true
  },
  {
    name_en: 'Ventilation',
    name_fr: 'Ventilation',
    name_de: 'Lüftung',
    name_it: 'Ventilazione',
    name_pt: 'Ventilação',
    name_es: 'Ventilación',
    slug: 'ventilation',
    description_en: 'Ventilation',
    description_fr: 'Ventilation',
    description_de: 'Lüftung',
    description_it: 'Ventilazione',
    description_pt: 'Ventilação',
    description_es: 'Ventilación',
    icon: 'category_20.svg',
    isActive: true
  },
  {
    name_en: 'Sanitary Installations',
    name_fr: 'Sanitaire',
    name_de: 'Sanitärinstallationen',
    name_it: 'Impianti Sanitari',
    name_pt: 'Instalações Sanitárias',
    name_es: 'Instalaciones Sanitarias',
    slug: 'sanitary-installations',
    description_en: 'Sanitary Installations',
    description_fr: 'Sanitaire',
    description_de: 'Sanitärinstallationen',
    description_it: 'Impianti Sanitari',
    description_pt: 'Instalações Sanitárias',
    description_es: 'Instalaciones Sanitarias',
    icon: 'category_21.svg',
    isActive: true
  },
  {
    name_en: 'Plumbing',
    name_fr: 'Plomberie',
    name_de: 'Installation von Sanitäranlagen',
    name_it: 'Idraulica',
    name_pt: 'Encanamento',
    name_es: 'Fontanería',
    slug: 'plumbing',
    description_en: 'Plumbing',
    description_fr: 'Plomberie',
    description_de: 'Installation von Sanitäranlagen',
    description_it: 'Idraulica',
    description_pt: 'Encanamento',
    description_es: 'Fontanería',
    icon: 'category_22.svg',
    isActive: true
  },
  {
    name_en: 'Solar Energy (panels, solar water heaters)',
    name_fr: 'Solaire (panneaux, chauffe-eau solaire)',
    name_de: 'Solarenergie (Paneele, Solarwarmwasserbereiter)',
    name_it: 'Energia Solare (pannelli, scaldacqua solari)',
    name_pt: 'Energia Solar (painéis, aquecedores solares de água)',
    name_es: 'Energía Solar (paneles, calentadores solares de agua)',
    slug: 'solar-energy',
    description_en: 'Solar Energy (panels, solar water heaters)',
    description_fr: 'Solaire (panneaux, chauffe-eau solaire)',
    description_de: 'Solarenergie (Paneele, Solarwarmwasserbereiter)',
    description_it: 'Energia Solare (pannelli, scaldacqua solari)',
    description_pt: 'Energia Solar (painéis, aquecedores solares de água)',
    description_es: 'Energía Solar (paneles, calentadores solares de agua)',
    icon: 'category_23.svg',
    isActive: true
  },
  {
    name_en: 'Home Automation / Smart Home',
    name_fr: 'Domotique / maison connectée',
    name_de: 'Hausautomation / Smart Home',
    name_it: 'Domotica / Casa Intelligente',
    name_pt: 'Domótica / Casa Inteligente',
    name_es: 'Domótica / Hogar Inteligente',
    slug: 'home-automation-smart-home',
    description_en: 'Home Automation / Smart Home',
    description_fr: 'Domotique / maison connectée',
    description_de: 'Hausautomation / Smart Home',
    description_it: 'Domotica / Casa Intelligente',
    description_pt: 'Domótica / Casa Inteligente',
    description_es: 'Domótica / Hogar Inteligente',
    icon: 'category_24.svg',
    isActive: true
  },
  {
    name_en: 'Chimney Sweeping',
    name_fr: 'Ramonage',
    name_de: 'Schornsteinreinigung',
    name_it: 'Spazzacamino',
    name_pt: 'Limpeza de Chaminés',
    name_es: 'Deshollinador',
    slug: 'chimney-sweeping',
    description_en: 'Chimney Sweeping',
    description_fr: 'Ramonage',
    description_de: 'Schornsteinreinigung',
    description_it: 'Spazzacamino',
    description_pt: 'Limpeza de Chaminés',
    description_es: 'Deshollinador',
    icon: 'category_25.svg',
    isActive: true
  },
  {
    name_en: 'Blinds and Windows',
    name_fr: 'Stores et fenêtres',
    name_de: 'Jalousien und Fenster',
    name_it: 'Tende e Finestre',
    name_pt: 'Estores e Janelas',
    name_es: 'Persianas y Ventanas',
    slug: 'blinds-windows',
    description_en: 'Blinds and Windows',
    description_fr: 'Stores et fenêtres',
    description_de: 'Jalousien und Fenster',
    description_it: 'Tende e Finestre',
    description_pt: 'Estores e Janelas',
    description_es: 'Persianas y Ventanas',
    icon: 'category_26.svg',
    isActive: true
  },
  {
    name_en: 'Glazing / Mirror Work',
    name_fr: 'Vitrerie / miroiterie',
    name_de: 'Verglasung / Spiegelarbeiten',
    name_it: 'Vetri / Specchi',
    name_pt: 'Vidraçaria / Trabalho com Espelhos',
    name_es: 'Acristalamiento / Espejos',
    slug: 'glazing-mirror-work',
    description_en: 'Glazing / Mirror Work',
    description_fr: 'Vitrerie / miroiterie',
    description_de: 'Verglasung / Spiegelarbeiten',
    description_it: 'Vetri / Specchi',
    description_pt: 'Vidraçaria / Trabalho com Espelhos',
    description_es: 'Acristalamiento / Espejos',
    icon: 'category_27.svg',
    isActive: true
  },
  {
    name_en: 'Locksmithing',
    name_fr: 'Serrurerie',
    name_de: 'Schlüsseldienst',
    name_it: 'Fabbricazione',
    name_pt: 'Chaveiro',
    name_es: 'Cerrajería',
    slug: 'locksmithing',
    description_en: 'Locksmithing',
    description_fr: 'Serrurerie',
    description_de: 'Schlüsseldienst',
    description_it: 'Fabbricazione',
    description_pt: 'Chaveiro',
    description_es: 'Cerrajería',
    icon: 'category_28.svg',
    isActive: true
  },
  {
    name_en: 'Alarms & Video Surveillance',
    name_fr: 'Alarmes & vidéo-surveillance',
    name_de: 'Alarmanlagen & Videoüberwachung',
    name_it: 'Allarmi e Videosorveglianza',
    name_pt: 'Alarmes e Videovigilância',
    name_es: 'Alarmas y Videovigilancia',
    slug: 'alarms-video-surveillance',
    description_en: 'Alarms & Video Surveillance',
    description_fr: 'Alarmes & vidéo-surveillance',
    description_de: 'Alarmanlagen & Videoüberwachung',
    description_it: 'Allarmi e Videosorveglianza',
    description_pt: 'Alarmes e Videovigilância',
    description_es: 'Alarmas y Videovigilancia',
    icon: 'category_29.svg',
    isActive: true
  },
  {
    name_en: 'Gardening / Landscaping',
    name_fr: 'Jardinage / Paysagiste',
    name_de: 'Gartenbau / Landschaftsgestaltung',
    name_it: 'Giardinaggio / Paesaggistica',
    name_pt: 'Jardinagem / Paisagismo',
    name_es: 'Jardinería / Paisajismo',
    slug: 'gardening-landscaping',
    description_en: 'Gardening / Landscaping',
    description_fr: 'Jardinage / Paysagiste',
    description_de: 'Gartenbau / Landschaftsgestaltung',
    description_it: 'Giardinaggio / Paesaggistica',
    description_pt: 'Jardinagem / Paisagismo',
    description_es: 'Jardinería / Paisajismo',
    icon: 'category_30.svg',
    isActive: true
  },
  {
    name_en: 'Pool Construction (building + maintenance)',
    name_fr: 'Pisciniste (construction + entretien)',
    name_de: 'Poolbau (Errichtung + Wartung)',
    name_it: 'Costruzione di Piscine (costruzione + manutenzione)',
    name_pt: 'Construção de Piscinas (construção + manutenção)',
    name_es: 'Construcción de Piscinas (edificación + mantenimiento)',
    slug: 'pool-construction',
    description_en: 'Pool Construction (building + maintenance)',
    description_fr: 'Pisciniste (construction + entretien)',
    description_de: 'Poolbau (Errichtung + Wartung)',
    description_it: 'Costruzione di Piscine (costruzione + manutenzione)',
    description_pt: 'Construção de Piscinas (construção + manutenção)',
    description_es: 'Construcción de Piscinas (edificación + mantenimiento)',
    icon: 'category_31.svg',
    isActive: true
  },
  {
    name_en: 'Earthmoving / Landscaping',
    name_fr: 'Terrassier / aménagement de terrain',
    name_de: 'Erdbau / Landschaftsgestaltung',
    name_it: 'Movimento Terra / Paesaggistica',
    name_pt: 'Terraplanagem / Paisagismo',
    name_es: 'Movimiento de Tierras / Paisajismo',
    slug: 'earthmoving-landscaping',
    description_en: 'Earthmoving / Landscaping',
    description_fr: 'Terrassier / aménagement de terrain',
    description_de: 'Erdbau / Landschaftsgestaltung',
    description_it: 'Movimento Terra / Paesaggistica',
    description_pt: 'Terraplanagem / Paisagismo',
    description_es: 'Movimiento de Tierras / Paisajismo',
    icon: 'category_32.svg',
    isActive: true
  },
  {
    name_en: 'Fences & Gates',
    name_fr: 'Clôtures & portails',
    name_de: 'Zäune & Tore',
    name_it: 'Recinzioni e Cancelli',
    name_pt: 'Vedações e Portões',
    name_es: 'Vallas y Portones',
    slug: 'fences-gates',
    description_en: 'Fences & Gates',
    description_fr: 'Clôtures & portails',
    description_de: 'Zäune & Tore',
    description_it: 'Recinzioni e Cancelli',
    description_pt: 'Vedações e Portões',
    description_es: 'Vallas y Portones',
    icon: 'category_33.svg',
    isActive: true
  },
  {
    name_en: 'Cleaning (house, windows, post-construction)',
    name_fr: 'Nettoyage (maison, vitres, fin de chantier)',
    name_de: 'Reinigung (Haus, Fenster, Bauendreinigung)',
    name_it: 'Pulizia (casa, finestre, post-costruzione)',
    name_pt: 'Limpeza (casa, janelas, pós-obra)',
    name_es: 'Limpieza (casa, ventanas, post-construcción)',
    slug: 'cleaning',
    description_en: 'Cleaning (house, windows, post-construction)',
    description_fr: 'Nettoyage (maison, vitres, fin de chantier)',
    description_de: 'Reinigung (Haus, Fenster, Bauendreinigung)',
    description_it: 'Pulizia (casa, finestre, post-costruzione)',
    description_pt: 'Limpeza (casa, janelas, pós-obra)',
    description_es: 'Limpieza (casa, ventanas, post-construcción)',
    icon: 'category_34.svg',
    isActive: true
  },
  {
    name_en: 'Auto Mechanics',
    name_fr: 'Mécanique auto',
    name_de: 'Kfz-Mechanik',
    name_it: 'Meccanica Auto',
    name_pt: 'Mecânica Automóvel',
    name_es: 'Mecánica de Automóviles',
    slug: 'auto-mechanics',
    description_en: 'Auto Mechanics',
    description_fr: 'Mécanique auto',
    description_de: 'Kfz-Mechanik',
    description_it: 'Meccanica Auto',
    description_pt: 'Mecânica Automóvel',
    description_es: 'Mecánica de Automóviles',
    icon: 'category_35.svg',
    isActive: true
  },
  {
    name_en: 'Mechanics Motorcycle',
    name_fr: 'Mécanique moto',
    name_de: 'Motorradmechanik',
    name_it: 'Meccanica Moto',
    name_pt: 'Mecânica de Motos',
    name_es: 'Mecánica de Motocicletas',
    slug: 'motorcycle-mechanics',
    description_en: 'Mechanics Motorcycle',
    description_fr: 'Mécanique moto',
    description_de: 'Motorradmechanik',
    description_it: 'Meccanica Moto',
    description_pt: 'Mecânica de Motos',
    description_es: 'Mecánica de Motocicletas',
    icon: 'category_36.svg',
    isActive: true
  },
  {
    name_en: 'Bodywork',
    name_fr: 'Carrosserie',
    name_de: 'Karosseriearbeiten',
    name_it: 'Carrozzeria',
    name_pt: 'Funilaria e Pintura',
    name_es: 'Carrocería',
    slug: 'bodywork',
    description_en: 'Bodywork',
    description_fr: 'Carrosserie',
    description_de: 'Karosseriearbeiten',
    description_it: 'Carrozzeria',
    description_pt: 'Funilaria e Pintura',
    description_es: 'Carrocería',
    icon: 'category_37.svg',
    isActive: true
  },
  {
    name_en: 'Transportation (taxi / private hire / small transport)',
    name_fr: 'Transports (taxi / VTC / petit transport)',
    name_de: 'Transport (Taxi / Mietwagen / Kleinbusse)',
    name_it: 'Trasporti (taxi / noleggio con conducente / piccoli trasporti)',
    name_pt: 'Transporte (táxi / aluguer com motorista / pequeno transporte)',
    name_es: 'Transporte (taxi / alquiler privado / pequeño transporte)',
    slug: 'transportation',
    description_en: 'Transportation (taxi / private hire / small transport)',
    description_fr: 'Transports (taxi / VTC / petit transport)',
    description_de: 'Transport (Taxi / Mietwagen / Kleinbusse)',
    description_it: 'Trasporti (taxi / noleggio con conducente / piccoli trasporti)',
    description_pt: 'Transporte (táxi / aluguer com motorista / pequeno transporte)',
    description_es: 'Transporte (taxi / alquiler privado / pequeño transporte)',
    icon: 'category_38.svg',
    isActive: true
  },
  {
    name_en: 'Moving',
    name_fr: 'Déménagement',
    name_de: 'Umzüge',
    name_it: 'Traslochi',
    name_pt: 'Mudanças',
    name_es: 'Mudanzas',
    slug: 'moving',
    description_en: 'Moving',
    description_fr: 'Déménagement',
    description_de: 'Umzüge',
    description_it: 'Traslochi',
    description_pt: 'Mudanças',
    description_es: 'Mudanzas',
    icon: 'category_39.svg',
    isActive: true
  },
  {
    name_en: 'Bakery',
    name_fr: 'Boulangerie-Pâtisserie',
    name_de: 'Bäckerei',
    name_it: 'Panetteria',
    name_pt: 'Padaria',
    name_es: 'Panadería',
    slug: 'bakery',
    description_en: 'Bakery',
    description_fr: 'Boulangerie-Pâtisserie',
    description_de: 'Bäckerei',
    description_it: 'Panetteria',
    description_pt: 'Padaria',
    description_es: 'Panadería',
    icon: 'category_40.svg',
    isActive: true
  },
  {
    name_en: 'Kitchen / Catering',
    name_fr: 'Cuisine / Traiteur',
    name_de: 'Küche / Catering',
    name_it: 'Cucina / Catering',
    name_pt: 'Cozinha / Catering',
    name_es: 'Cocina / Catering',
    slug: 'kitchen-catering',
    description_en: 'Kitchen / Catering',
    description_fr: 'Cuisine / Traiteur',
    description_de: 'Küche / Catering',
    description_it: 'Cucina / Catering',
    description_pt: 'Cozinha / Catering',
    description_es: 'Cocina / Catering',
    icon: 'category_41.svg',
    isActive: true
  },
  {
    name_en: 'Tailor',
    name_fr: 'Couturier',
    name_de: 'Schneider',
    name_it: 'Sartoria',
    name_pt: 'Alfaiate',
    name_es: 'Sastrería',
    slug: 'tailor',
    description_en: 'Tailor',
    description_fr: 'Couturier',
    description_de: 'Schneider',
    description_it: 'Sartoria',
    description_pt: 'Alfaiate',
    description_es: 'Sastrería',
    icon: 'category_42.svg',
    isActive: true
  },
  {
    name_en: 'IT / IT Troubleshooting / IT Development',
    name_fr: 'IT / Dépannage IT / Developpement IT',
    name_de: 'IT / IT-Fehlerbehebung / IT-Entwicklung',
    name_it: 'IT / Risoluzione problemi IT / Sviluppo IT',
    name_pt: 'TI / Resolução de problemas de TI / Desenvolvimento de TI',
    name_es: 'Informática / Solución de problemas informáticos / Desarrollo informático',
    slug: 'it-services',
    description_en: 'IT / IT Troubleshooting / IT Development',
    description_fr: 'IT / Dépannage IT / Developpement IT',
    description_de: 'IT / IT-Fehlerbehebung / IT-Entwicklung',
    description_it: 'IT / Risoluzione problemi IT / Sviluppo IT',
    description_pt: 'TI / Resolução de problemas de TI / Desenvolvimento de TI',
    description_es: 'Informática / Solución de problemas informáticos / Desarrollo informático',
    icon: 'category_43.svg',
    isActive: true
  },
  {
    name_en: 'Network & Wi-Fi Installation',
    name_fr: 'Installation réseau & Wi-Fi',
    name_de: 'Netzwerk- und WLAN-Installation',
    name_it: 'Installazione reti e Wi-Fi',
    name_pt: 'Instalação de rede e Wi-Fi',
    name_es: 'Instalación de redes y wifi',
    slug: 'network-wifi-installation',
    description_en: 'Network & Wi-Fi Installation',
    description_fr: 'Installation réseau & Wi-Fi',
    description_de: 'Netzwerk- und WLAN-Installation',
    description_it: 'Installazione reti e Wi-Fi',
    description_pt: 'Instalação de rede e Wi-Fi',
    description_es: 'Instalación de redes y wifi',
    icon: 'category_44.svg',
    isActive: true
  },
  {
    name_en: 'Graphic Design',
    name_fr: 'Graphisme / design visuel',
    name_de: 'Grafikdesign',
    name_it: 'Grafica',
    name_pt: 'Design gráfico',
    name_es: 'Diseño gráfico',
    slug: 'graphic-design',
    description_en: 'Graphic Design',
    description_fr: 'Graphisme / design visuel',
    description_de: 'Grafikdesign',
    description_it: 'Grafica',
    description_pt: 'Design gráfico',
    description_es: 'Diseño gráfico',
    icon: 'category_45.svg',
    isActive: true
  }
];

// export async function seedCategories() {
//   console.log('🌱 Seeding categories...');
  
//   // Clear existing categories
//   await prisma.category.deleteMany();
  
//   // Create categories
//   const categories = [];
//   for (const categoryData of categoriesData) {
//     const category = await prisma.category.create({
//       data: categoryData
//     });
//     categories.push(category);
//   }
  
//   console.log(`✅ Created ${categories.length} categories`);
//   return categories;
// }
export async function seedCategories() {
  console.log('🌱 Seeding categories...');
  
  // Use createMany with skipDuplicates to avoid deleting anything
  const result = await prisma.category.createMany({
    data: categoriesData,
    skipDuplicates: true, // This prevents errors for duplicate entries
  });
  
  console.log(`✅ Created ${result.count} new categories`);
}
// Run if this file is executed directly
if (require.main === module) {
  seedCategories()
    .catch((e) => {
      console.error('❌ Category seeding failed:', e);
      process.exit(1);
    })
    .finally(async () => {
      await prisma.$disconnect();
    });
}