import { PrismaClient } from "@prisma/client";

const prisma = new PrismaClient();

async function seedCountries() {
  try {
    console.log("🌍 Starting to seed countries with extended fields...");

    const countries = [
      {
        id: "switzerland",
        name: "Switzerland",
        code: "CH",
        domain: "smile24.ch",
        languages: JSON.stringify(["de", "fr", "it", "en"]),
        defaultLanguage: "de",
        currency: "CHF",
        currencySymbol: "CHF",
        packagePrice: 19.9,
        paymentGateways: JSON.stringify(["stripe", "twint"]),
        isActive: true,
        customerPhone:"+65673547367",
        logoHeader: "/assets/image/logo.png",
        logoFooter: "/assets/image/logo.png",
        supportEmail: "support@smile24.ch",
        businessEmail: "business@smile24.ch",
        mapIframe: `https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2701.8329028041794!2d8.537194576689535!3d47.37617970386029!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x47900a062ef36881%3A0xba2862db8cf7a41!2sBahnhofstrasse%20100%2C%208001%20Z%C3%BCrich%2C%20Switzerland!5e0!3m2!1sen!2sin!4v1751281564242!5m2!1sen!2sin" width="100%" height="312" loading="lazy`,

        location_en: "Paris, France",
        location_fr: "Paris, France",
        location_de: "Paris, Frankreich",
        location_it: "Parigi, Francia",
        location_pt: "Paris, França",
        location_es: "París, Francia",

        sublocation_en: "Western Europe",
        sublocation_fr: "Europe de l'Ouest",
        sublocation_de: "Westeuropa",
        sublocation_it: "Europa occidentale",
        sublocation_pt: "Europa Ocidental",
        sublocation_es: "Europa Occidental",

        shortDescription_en:
          "Experience the elegance and excellence of France, where innovation meets refined craftsmanship. We deliver premium services rooted in quality, reliability, and a deep commitment to customer satisfaction.",

        shortDescription_fr:
          "Découvrez l’élégance et l’excellence françaises, où l’innovation rencontre un savoir-faire raffiné. Nous offrons des services haut de gamme fondés sur la qualité, la fiabilité et un engagement profond envers la satisfaction client.",

        shortDescription_de:
          "Erleben Sie französische Eleganz und Spitzenqualität – dort, wo Innovation auf feine Handwerkskunst trifft. Wir bieten Premium-Dienstleistungen, die auf Qualität, Zuverlässigkeit und echter Kundenzufriedenheit basieren.",

        shortDescription_it:
          "Vivi l’eleganza e l’eccellenza della Francia, dove l’innovazione incontra un’artigianalità raffinata. Offriamo servizi premium basati su qualità, affidabilità e un forte impegno verso la soddisfazione del cliente.",

        shortDescription_pt:
          "Experimente a elegância e excelência da França, onde a inovação se une ao artesanato refinado. Oferecemos serviços premium baseados em qualidade, confiabilidade e um profundo compromisso com a satisfação do cliente.",

        shortDescription_es:
          "Experimenta la elegancia y excelencia de Francia, donde la innovación se combina con la artesanía refinada. Ofrecemos servicios premium basados en calidad, confiabilidad y un fuerte compromiso con la satisfacción del cliente.",

        facebookUrl: "https://facebook.com/",
        twitterUrl: "https://twitter.com/",
        instagramUrl: "https://instagram.com/",
        linkedinUrl: "https://linkedin./",
        googleUrl: "https://google.com/",
      },
      {
        id: "luxembourg",
        name: "Luxembourg",
        code: "LU",
        domain: "smile24.lu",
        languages: JSON.stringify(["de", "fr", "it", "en"]),
        defaultLanguage: "fr",
        currency: "EUR",
        currencySymbol: "€",
        packagePrice: 9.9,
        paymentGateways: JSON.stringify(["stripe", "twint"]),
        isActive: true,
        mapIframe: `https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2701.8329028041794!2d8.537194576689535!3d47.37617970386029!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x47900a062ef36881%3A0xba2862db8cf7a41!2sBahnhofstrasse%20100%2C%208001%20Z%C3%BCrich%2C%20Switzerland!5e0!3m2!1sen!2sin!4v1751281564242!5m2!1sen!2sin" width="100%" height="312" loading="lazy`,
        logoHeader: "/assets/image/logo.png",
        logoFooter: "/assets/image/logo.png",
        supportEmail: "support@smile24.lu",
        businessEmail: "business@smile24.lu",
        location_en: "Paris, France",
        location_fr: "Paris, France",
        location_de: "Paris, Frankreich",
        location_it: "Parigi, Francia",
        location_pt: "Paris, França",
        location_es: "París, Francia",
customerPhone:"+65673547367",
        sublocation_en: "Western Europe",
        sublocation_fr: "Europe de l'Ouest",
        sublocation_de: "Westeuropa",
        sublocation_it: "Europa occidentale",
        sublocation_pt: "Europa Ocidental",
        sublocation_es: "Europa Occidental",

        shortDescription_en:
          "Experience the elegance and excellence of France, where innovation meets refined craftsmanship. We deliver premium services rooted in quality, reliability, and a deep commitment to customer satisfaction.",

        shortDescription_fr:
          "Découvrez l’élégance et l’excellence françaises, où l’innovation rencontre un savoir-faire raffiné. Nous offrons des services haut de gamme fondés sur la qualité, la fiabilité et un engagement profond envers la satisfaction client.",

        shortDescription_de:
          "Erleben Sie französische Eleganz und Spitzenqualität – dort, wo Innovation auf feine Handwerkskunst trifft. Wir bieten Premium-Dienstleistungen, die auf Qualität, Zuverlässigkeit und echter Kundenzufriedenheit basieren.",

        shortDescription_it:
          "Vivi l’eleganza e l’eccellenza della Francia, dove l’innovazione incontra un’artigianalità raffinata. Offriamo servizi premium basati su qualità, affidabilità e un forte impegno verso la soddisfazione del cliente.",

        shortDescription_pt:
          "Experimente a elegância e excelência da França, onde a inovação se une ao artesanato refinado. Oferecemos serviços premium baseados em qualidade, confiabilidade e um profundo compromisso com a satisfação do cliente.",

        shortDescription_es:
          "Experimenta la elegancia y excelencia de Francia, donde la innovación se combina con la artesanía refinada. Ofrecemos servicios premium basados en calidad, confiabilidad y un fuerte compromiso con la satisfacción del cliente.",

        facebookUrl: "https://facebook.com/",
        twitterUrl: "https://twitter.com/",
        instagramUrl: "https://instagram.com/",
        linkedinUrl: "https://linkedin./",
        googleUrl: "https://google.com/",
      },
      {
        id: "belgium",
        name: "Belgium",
        code: "BE",
        domain: "smile24.be",
        languages: JSON.stringify(["fr", "nl", "de", "en"]),
        defaultLanguage: "fr",
        currency: "EUR",
        currencySymbol: "€",
        packagePrice: 9.9,
        paymentGateways: JSON.stringify(["stripe"]),
        isActive: true,
        customerPhone:"+65673547367",
        mapIframe: `https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2701.8329028041794!2d8.537194576689535!3d47.37617970386029!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x47900a062ef36881%3A0xba2862db8cf7a41!2sBahnhofstrasse%20100%2C%208001%20Z%C3%BCrich%2C%20Switzerland!5e0!3m2!1sen!2sin!4v1751281564242!5m2!1sen!2sin" width="100%" height="312" loading="lazy`,
        logoHeader: "/assets/image/logo.png",
        logoFooter: "/assets/image/logo.png",
        supportEmail: "support@smile24.be",
        businessEmail: "business@smile24.be",
        location_en: "Paris, France",
        location_fr: "Paris, France",
        location_de: "Paris, Frankreich",
        location_it: "Parigi, Francia",
        location_pt: "Paris, França",
        location_es: "París, Francia",

        sublocation_en: "Western Europe",
        sublocation_fr: "Europe de l'Ouest",
        sublocation_de: "Westeuropa",
        sublocation_it: "Europa occidentale",
        sublocation_pt: "Europa Ocidental",
        sublocation_es: "Europa Occidental",

        shortDescription_en:
          "Experience the elegance and excellence of France, where innovation meets refined craftsmanship. We deliver premium services rooted in quality, reliability, and a deep commitment to customer satisfaction.",

        shortDescription_fr:
          "Découvrez l’élégance et l’excellence françaises, où l’innovation rencontre un savoir-faire raffiné. Nous offrons des services haut de gamme fondés sur la qualité, la fiabilité et un engagement profond envers la satisfaction client.",

        shortDescription_de:
          "Erleben Sie französische Eleganz und Spitzenqualität – dort, wo Innovation auf feine Handwerkskunst trifft. Wir bieten Premium-Dienstleistungen, die auf Qualität, Zuverlässigkeit und echter Kundenzufriedenheit basieren.",

        shortDescription_it:
          "Vivi l’eleganza e l’eccellenza della Francia, dove l’innovazione incontra un’artigianalità raffinata. Offriamo servizi premium basati su qualità, affidabilità e un forte impegno verso la soddisfazione del cliente.",

        shortDescription_pt:
          "Experimente a elegância e excelência da França, onde a inovação se une ao artesanato refinado. Oferecemos serviços premium baseados em qualidade, confiabilidade e um profundo compromisso com a satisfação do cliente.",

        shortDescription_es:
          "Experimenta la elegancia y excelencia de Francia, donde la innovación se combina con la artesanía refinada. Ofrecemos servicios premium basados en calidad, confiabilidad y un fuerte compromiso con la satisfacción del cliente.",

        facebookUrl: "https://facebook.com/",
        twitterUrl: "https://twitter.com/",
        instagramUrl: "https://instagram.com/",
        linkedinUrl: "https://linkedin./",
        googleUrl: "https://google.com/",
      },
      {
        id: "france",
        name: "France",
        code: "FR",
        domain: "smile24.fr",
        languages: JSON.stringify(["fr", "en"]),
        defaultLanguage: "fr",
        currency: "EUR",
        customerPhone:"+65673547367",
        mapIframe: `https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2701.8329028041794!2d8.537194576689535!3d47.37617970386029!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x47900a062ef36881%3A0xba2862db8cf7a41!2sBahnhofstrasse%20100%2C%208001%20Z%C3%BCrich%2C%20Switzerland!5e0!3m2!1sen!2sin!4v1751281564242!5m2!1sen!2sin" width="100%" height="312" loading="lazy`,
        currencySymbol: "€",
        packagePrice: 9.9,
        paymentGateways: JSON.stringify(["stripe"]),
        isActive: true,

        logoHeader: "/assets/image/logo.png",
        logoFooter: "/assets/image/logo.png",
        supportEmail: "support@smile24.fr",
        businessEmail: "business@smile24.fr",

        location_en: "Paris, France",
        location_fr: "Paris, France",
        location_de: "Paris, Frankreich",
        location_it: "Parigi, Francia",
        location_pt: "Paris, França",
        location_es: "París, Francia",

        sublocation_en: "Western Europe",
        sublocation_fr: "Europe de l'Ouest",
        sublocation_de: "Westeuropa",
        sublocation_it: "Europa occidentale",
        sublocation_pt: "Europa Ocidental",
        sublocation_es: "Europa Occidental",

        shortDescription_en:
          "Experience the elegance and excellence of France, where innovation meets refined craftsmanship. We deliver premium services rooted in quality, reliability, and a deep commitment to customer satisfaction.",

        shortDescription_fr:
          "Découvrez l’élégance et l’excellence françaises, où l’innovation rencontre un savoir-faire raffiné. Nous offrons des services haut de gamme fondés sur la qualité, la fiabilité et un engagement profond envers la satisfaction client.",

        shortDescription_de:
          "Erleben Sie französische Eleganz und Spitzenqualität – dort, wo Innovation auf feine Handwerkskunst trifft. Wir bieten Premium-Dienstleistungen, die auf Qualität, Zuverlässigkeit und echter Kundenzufriedenheit basieren.",

        shortDescription_it:
          "Vivi l’eleganza e l’eccellenza della Francia, dove l’innovazione incontra un’artigianalità raffinata. Offriamo servizi premium basati su qualità, affidabilità e un forte impegno verso la soddisfazione del cliente.",

        shortDescription_pt:
          "Experimente a elegância e excelência da França, onde a inovação se une ao artesanato refinado. Oferecemos serviços premium baseados em qualidade, confiabilidade e um profundo compromisso com a satisfação do cliente.",

        shortDescription_es:
          "Experimenta la elegancia y excelencia de Francia, donde la innovación se combina con la artesanía refinada. Ofrecemos servicios premium basados en calidad, confiabilidad y un fuerte compromiso con la satisfacción del cliente.",

        facebookUrl: "https://facebook.com/",
        twitterUrl: "https://twitter.com/",
        instagramUrl: "https://instagram.com/",
        linkedinUrl: "https://linkedin./",
        googleUrl: "https://google.com/",
      },
      {
        id: "italy",
        name: "Italy",
        code: "IT",
        customerPhone:"+65673547367",
        domain: "smile24.it",
        languages: JSON.stringify(["it", "en"]),
        defaultLanguage: "it",
        currency: "EUR",
        currencySymbol: "€",
        packagePrice: 9.9,
        paymentGateways: JSON.stringify(["stripe"]),
        isActive: true,
        mapIframe: `https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2701.8329028041794!2d8.537194576689535!3d47.37617970386029!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x47900a062ef36881%3A0xba2862db8cf7a41!2sBahnhofstrasse%20100%2C%208001%20Z%C3%BCrich%2C%20Switzerland!5e0!3m2!1sen!2sin!4v1751281564242!5m2!1sen!2sin" width="100%" height="312" loading="lazy`,
        logoHeader: "/assets/image/logo.png",
        logoFooter: "/assets/image/logo.png",
        supportEmail: "support@smile24.it",
        businessEmail: "business@smile24.it",
        location_en: "Paris, France",
        location_fr: "Paris, France",
        location_de: "Paris, Frankreich",
        location_it: "Parigi, Francia",
        location_pt: "Paris, França",
        location_es: "París, Francia",

        sublocation_en: "Western Europe",
        sublocation_fr: "Europe de l'Ouest",
        sublocation_de: "Westeuropa",
        sublocation_it: "Europa occidentale",
        sublocation_pt: "Europa Ocidental",
        sublocation_es: "Europa Occidental",

        shortDescription_en:
          "Experience the elegance and excellence of France, where innovation meets refined craftsmanship. We deliver premium services rooted in quality, reliability, and a deep commitment to customer satisfaction.",

        shortDescription_fr:
          "Découvrez l’élégance et l’excellence françaises, où l’innovation rencontre un savoir-faire raffiné. Nous offrons des services haut de gamme fondés sur la qualité, la fiabilité et un engagement profond envers la satisfaction client.",

        shortDescription_de:
          "Erleben Sie französische Eleganz und Spitzenqualität – dort, wo Innovation auf feine Handwerkskunst trifft. Wir bieten Premium-Dienstleistungen, die auf Qualität, Zuverlässigkeit und echter Kundenzufriedenheit basieren.",

        shortDescription_it:
          "Vivi l’eleganza e l’eccellenza della Francia, dove l’innovazione incontra un’artigianalità raffinata. Offriamo servizi premium basati su qualità, affidabilità e un forte impegno verso la soddisfazione del cliente.",

        shortDescription_pt:
          "Experimente a elegância e excelência da França, onde a inovação se une ao artesanato refinado. Oferecemos serviços premium baseados em qualidade, confiabilidade e um profundo compromisso com a satisfação do cliente.",

        shortDescription_es:
          "Experimenta la elegancia y excelencia de Francia, donde la innovación se combina con la artesanía refinada. Ofrecemos servicios premium basados en calidad, confiabilidad y un fuerte compromiso con la satisfacción del cliente.",

        facebookUrl: "https://facebook.com/",
        twitterUrl: "https://twitter.com/",
        instagramUrl: "https://instagram.com/",
        linkedinUrl: "https://linkedin./",
        googleUrl: "https://google.com/",
      },
      {
        id: "uk",
        name: "United Kingdom",
        code: "GB",
        domain: "smile24.uk",
        languages: JSON.stringify(["en"]),
        defaultLanguage: "en",
        currency: "GBP",
        currencySymbol: "£",
        packagePrice: 9.9,
        paymentGateways: JSON.stringify(["stripe"]),
        isActive: true,
        customerPhone:"+65673547367",
        mapIframe: `https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2701.8329028041794!2d8.537194576689535!3d47.37617970386029!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x47900a062ef36881%3A0xba2862db8cf7a41!2sBahnhofstrasse%20100%2C%208001%20Z%C3%BCrich%2C%20Switzerland!5e0!3m2!1sen!2sin!4v1751281564242!5m2!1sen!2sin" width="100%" height="312" loading="lazy`,
        logoHeader: "/assets/image/logo.png",
        logoFooter: "/assets/image/logo.png",
        supportEmail: "support@smile24.uk",
        businessEmail: "business@smile24.uk",
        location_en: "Paris, France",
        location_fr: "Paris, France",
        location_de: "Paris, Frankreich",
        location_it: "Parigi, Francia",
        location_pt: "Paris, França",
        location_es: "París, Francia",

        sublocation_en: "Western Europe",
        sublocation_fr: "Europe de l'Ouest",
        sublocation_de: "Westeuropa",
        sublocation_it: "Europa occidentale",
        sublocation_pt: "Europa Ocidental",
        sublocation_es: "Europa Occidental",

        shortDescription_en:
          "Experience the elegance and excellence of France, where innovation meets refined craftsmanship. We deliver premium services rooted in quality, reliability, and a deep commitment to customer satisfaction.",

        shortDescription_fr:
          "Découvrez l’élégance et l’excellence françaises, où l’innovation rencontre un savoir-faire raffiné. Nous offrons des services haut de gamme fondés sur la qualité, la fiabilité et un engagement profond envers la satisfaction client.",

        shortDescription_de:
          "Erleben Sie französische Eleganz und Spitzenqualität – dort, wo Innovation auf feine Handwerkskunst trifft. Wir bieten Premium-Dienstleistungen, die auf Qualität, Zuverlässigkeit und echter Kundenzufriedenheit basieren.",

        shortDescription_it:
          "Vivi l’eleganza e l’eccellenza della Francia, dove l’innovazione incontra un’artigianalità raffinata. Offriamo servizi premium basati su qualità, affidabilità e un forte impegno verso la soddisfazione del cliente.",

        shortDescription_pt:
          "Experimente a elegância e excelência da França, onde a inovação se une ao artesanato refinado. Oferecemos serviços premium baseados em qualidade, confiabilidade e um profundo compromisso com a satisfação do cliente.",

        shortDescription_es:
          "Experimenta la elegancia y excelencia de Francia, donde la innovación se combina con la artesanía refinada. Ofrecemos servicios premium basados en calidad, confiabilidad y un fuerte compromiso con la satisfacción del cliente.",

        facebookUrl: "https://facebook.com/",
        twitterUrl: "https://twitter.com/",
        instagramUrl: "https://instagram.com/",
        linkedinUrl: "https://linkedin./",
        googleUrl: "https://google.com/",
      },
      {
        id: "portugal",
        name: "Portugal",
        code: "PT",
        domain: "smile24.pt",
        languages: JSON.stringify(["pt", "en"]),
        defaultLanguage: "pt",
        currency: "EUR",
        currencySymbol: "€",
        customerPhone:"+65673547367",
        packagePrice: 9.9,
        paymentGateways: JSON.stringify(["stripe"]),
        isActive: true,
        mapIframe: `https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2701.8329028041794!2d8.537194576689535!3d47.37617970386029!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x47900a062ef36881%3A0xba2862db8cf7a41!2sBahnhofstrasse%20100%2C%208001%20Z%C3%BCrich%2C%20Switzerland!5e0!3m2!1sen!2sin!4v1751281564242!5m2!1sen!2sin" width="100%" height="312" loading="lazy`,

        logoHeader: "/assets/image/logo.png",
        logoFooter: "/assets/image/logo.png",
        supportEmail: "support@smile24.pt",
        businessEmail: "business@smile24.pt",

        location_en: "Paris, France",
        location_fr: "Paris, France",
        location_de: "Paris, Frankreich",
        location_it: "Parigi, Francia",
        location_pt: "Paris, França",
        location_es: "París, Francia",

        sublocation_en: "Western Europe",
        sublocation_fr: "Europe de l'Ouest",
        sublocation_de: "Westeuropa",
        sublocation_it: "Europa occidentale",
        sublocation_pt: "Europa Ocidental",
        sublocation_es: "Europa Occidental",

        shortDescription_en:
          "Experience the elegance and excellence of France, where innovation meets refined craftsmanship. We deliver premium services rooted in quality, reliability, and a deep commitment to customer satisfaction.",

        shortDescription_fr:
          "Découvrez l’élégance et l’excellence françaises, où l’innovation rencontre un savoir-faire raffiné. Nous offrons des services haut de gamme fondés sur la qualité, la fiabilité et un engagement profond envers la satisfaction client.",

        shortDescription_de:
          "Erleben Sie französische Eleganz und Spitzenqualität – dort, wo Innovation auf feine Handwerkskunst trifft. Wir bieten Premium-Dienstleistungen, die auf Qualität, Zuverlässigkeit und echter Kundenzufriedenheit basieren.",

        shortDescription_it:
          "Vivi l’eleganza e l’eccellenza della Francia, dove l’innovazione incontra un’artigianalità raffinata. Offriamo servizi premium basati su qualità, affidabilità e un forte impegno verso la soddisfazione del cliente.",

        shortDescription_pt:
          "Experimente a elegância e excelência da França, onde a inovação se une ao artesanato refinado. Oferecemos serviços premium baseados em qualidade, confiabilidade e um profundo compromisso com a satisfação do cliente.",

        shortDescription_es:
          "Experimenta la elegancia y excelencia de Francia, donde la innovación se combina con la artesanía refinada. Ofrecemos servicios premium basados en calidad, confiabilidad y un fuerte compromiso con la satisfacción del cliente.",

        facebookUrl: "https://facebook.com/",
        twitterUrl: "https://twitter.com/",
        instagramUrl: "https://instagram.com/",
        linkedinUrl: "https://linkedin./",
        googleUrl: "https://google.com/",
      },
      {
        id: "spain",
        name: "Spain",
        code: "ES",
        domain: "smile24.es",
        languages: JSON.stringify(["es", "en"]),
        defaultLanguage: "es",
        currency: "EUR",
        currencySymbol: "€",
        packagePrice: 9.9,
        paymentGateways: JSON.stringify(["stripe"]),
        isActive: true,
        mapIframe: `https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2701.8329028041794!2d8.537194576689535!3d47.37617970386029!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x47900a062ef36881%3A0xba2862db8cf7a41!2sBahnhofstrasse%20100%2C%208001%20Z%C3%BCrich%2C%20Switzerland!5e0!3m2!1sen!2sin!4v1751281564242!5m2!1sen!2sin" width="100%" height="312" loading="lazy`,

        logoHeader: "/assets/image/logo.png",
        logoFooter: "/assets/image/logo.png",
        supportEmail: "support@smile24.es",
        businessEmail: "business@smile24.es",

        location_en: "Paris, France",
        location_fr: "Paris, France",
        location_de: "Paris, Frankreich",
        location_it: "Parigi, Francia",
        location_pt: "Paris, França",
        location_es: "París, Francia",
customerPhone:"+65673547367",
        sublocation_en: "Western Europe",
        sublocation_fr: "Europe de l'Ouest",
        sublocation_de: "Westeuropa",
        sublocation_it: "Europa occidentale",
        sublocation_pt: "Europa Ocidental",
        sublocation_es: "Europa Occidental",

        shortDescription_en:
          "Experience the elegance and excellence of France, where innovation meets refined craftsmanship. We deliver premium services rooted in quality, reliability, and a deep commitment to customer satisfaction.",

        shortDescription_fr:
          "Découvrez l’élégance et l’excellence françaises, où l’innovation rencontre un savoir-faire raffiné. Nous offrons des services haut de gamme fondés sur la qualité, la fiabilité et un engagement profond envers la satisfaction client.",

        shortDescription_de:
          "Erleben Sie französische Eleganz und Spitzenqualität – dort, wo Innovation auf feine Handwerkskunst trifft. Wir bieten Premium-Dienstleistungen, die auf Qualität, Zuverlässigkeit und echter Kundenzufriedenheit basieren.",

        shortDescription_it:
          "Vivi l’eleganza e l’eccellenza della Francia, dove l’innovazione incontra un’artigianalità raffinata. Offriamo servizi premium basati su qualità, affidabilità e un forte impegno verso la soddisfazione del cliente.",

        shortDescription_pt:
          "Experimente a elegância e excelência da França, onde a inovação se une ao artesanato refinado. Oferecemos serviços premium baseados em qualidade, confiabilidade e um profundo compromisso com a satisfação do cliente.",

        shortDescription_es:
          "Experimenta la elegancia y excelencia de Francia, donde la innovación se combina con la artesanía refinada. Ofrecemos servicios premium basados en calidad, confiabilidad y un fuerte compromiso con la satisfacción del cliente.",

        facebookUrl: "https://facebook.com/",
        twitterUrl: "https://twitter.com/",
        instagramUrl: "https://instagram.com/",
        linkedinUrl: "https://linkedin./",
        googleUrl: "https://google.com/",
      },
      {
        id: "germany",
        name: "Germany",
        code: "DE",
        domain: "smile77.de",
        languages: JSON.stringify(["de", "en"]),
        defaultLanguage: "de",
        currency: "EUR",
        currencySymbol: "€",
        customerPhone:"+65673547367",
        packagePrice: 9.9,
        paymentGateways: JSON.stringify(["stripe"]),
        isActive: true,
        mapIframe: `https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2701.8329028041794!2d8.537194576689535!3d47.37617970386029!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x47900a062ef36881%3A0xba2862db8cf7a41!2sBahnhofstrasse%20100%2C%208001%20Z%C3%BCrich%2C%20Switzerland!5e0!3m2!1sen!2sin!4v1751281564242!5m2!1sen!2sin" width="100%" height="312" loading="lazy`,
        logoHeader: "/assets/image/logo.png",
        logoFooter: "/assets/image/logo.png",
        supportEmail: "support@smile77.de",
        businessEmail: "business@smile77.de",

        location_en: "Paris, France",
        location_fr: "Paris, France",
        location_de: "Paris, Frankreich",
        location_it: "Parigi, Francia",
        location_pt: "Paris, França",
        location_es: "París, Francia",

        sublocation_en: "Western Europe",
        sublocation_fr: "Europe de l'Ouest",
        sublocation_de: "Westeuropa",
        sublocation_it: "Europa occidentale",
        sublocation_pt: "Europa Ocidental",
        sublocation_es: "Europa Occidental",

        shortDescription_en:
          "Experience the elegance and excellence of France, where innovation meets refined craftsmanship. We deliver premium services rooted in quality, reliability, and a deep commitment to customer satisfaction.",

        shortDescription_fr:
          "Découvrez l’élégance et l’excellence françaises, où l’innovation rencontre un savoir-faire raffiné. Nous offrons des services haut de gamme fondés sur la qualité, la fiabilité et un engagement profond envers la satisfaction client.",

        shortDescription_de:
          "Erleben Sie französische Eleganz und Spitzenqualität – dort, wo Innovation auf feine Handwerkskunst trifft. Wir bieten Premium-Dienstleistungen, die auf Qualität, Zuverlässigkeit und echter Kundenzufriedenheit basieren.",

        shortDescription_it:
          "Vivi l’eleganza e l’eccellenza della Francia, dove l’innovazione incontra un’artigianalità raffinata. Offriamo servizi premium basati su qualità, affidabilità e un forte impegno verso la soddisfazione del cliente.",

        shortDescription_pt:
          "Experimente a elegância e excelência da França, onde a inovação se une ao artesanato refinado. Oferecemos serviços premium baseados em qualidade, confiabilidade e um profundo compromisso com a satisfação do cliente.",

        shortDescription_es:
          "Experimenta la elegancia y excelencia de Francia, donde la innovación se combina con la artesanía refinada. Ofrecemos servicios premium basados en calidad, confiabilidad y un fuerte compromiso con la satisfacción del cliente.",

        facebookUrl: "https://facebook.com/",
        twitterUrl: "https://twitter.com/",
        instagramUrl: "https://instagram.com/",
        linkedinUrl: "https://linkedin./",
        googleUrl: "https://google.com/",
      },
      {
        id: "austria",
        name: "Austria",
        code: "AT",
        domain: "smile77.at",
        customerPhone:"+65673547367",
        languages: JSON.stringify(["de", "en"]),
        defaultLanguage: "de",
        currency: "EUR",
        currencySymbol: "€",
        packagePrice: 9.9,
        paymentGateways: JSON.stringify(["stripe"]),
        isActive: true,
        mapIframe: `https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2701.8329028041794!2d8.537194576689535!3d47.37617970386029!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x47900a062ef36881%3A0xba2862db8cf7a41!2sBahnhofstrasse%20100%2C%208001%20Z%C3%BCrich%2C%20Switzerland!5e0!3m2!1sen!2sin!4v1751281564242!5m2!1sen!2sin" width="100%" height="312" loading="lazy`,
        logoHeader: "/assets/image/logo.png",
        logoFooter: "/assets/image/logo.png",
        supportEmail: "support@smile77.at",
        businessEmail: "business@smile77.at",
        location_en: "Paris, France",
        location_fr: "Paris, France",
        location_de: "Paris, Frankreich",
        location_it: "Parigi, Francia",
        location_pt: "Paris, França",
        location_es: "París, Francia",

        sublocation_en: "Western Europe",
        sublocation_fr: "Europe de l'Ouest",
        sublocation_de: "Westeuropa",
        sublocation_it: "Europa occidentale",
        sublocation_pt: "Europa Ocidental",
        sublocation_es: "Europa Occidental",

        shortDescription_en:
          "Experience the elegance and excellence of France, where innovation meets refined craftsmanship. We deliver premium services rooted in quality, reliability, and a deep commitment to customer satisfaction.",

        shortDescription_fr:
          "Découvrez l’élégance et l’excellence françaises, où l’innovation rencontre un savoir-faire raffiné. Nous offrons des services haut de gamme fondés sur la qualité, la fiabilité et un engagement profond envers la satisfaction client.",

        shortDescription_de:
          "Erleben Sie französische Eleganz und Spitzenqualität – dort, wo Innovation auf feine Handwerkskunst trifft. Wir bieten Premium-Dienstleistungen, die auf Qualität, Zuverlässigkeit und echter Kundenzufriedenheit basieren.",

        shortDescription_it:
          "Vivi l’eleganza e l’eccellenza della Francia, dove l’innovazione incontra un’artigianalità raffinata. Offriamo servizi premium basati su qualità, affidabilità e un forte impegno verso la soddisfazione del cliente.",

        shortDescription_pt:
          "Experimente a elegância e excelência da França, onde a inovação se une ao artesanato refinado. Oferecemos serviços premium baseados em qualidade, confiabilidade e um profundo compromisso com a satisfação do cliente.",

        shortDescription_es:
          "Experimenta la elegancia y excelencia de Francia, donde la innovación se combina con la artesanía refinada. Ofrecemos servicios premium basados en calidad, confiabilidad y un fuerte compromiso con la satisfacción del cliente.",

        facebookUrl: "https://facebook.com/",
        twitterUrl: "https://twitter.com/",
        instagramUrl: "https://instagram.com/",
        linkedinUrl: "https://linkedin./",
        googleUrl: "https://google.com/",
      },
    ];

    // Upsert countries with proper createdAt and updatedAt
    for (const countryData of countries) {
      await prisma.country.upsert({
        where: { id: countryData.id },
        update: {
          ...countryData,
          updatedAt: new Date(),
        },
        create: {
          ...countryData,
          createdAt: new Date(),
          updatedAt: new Date(),
        },
      });
    }

    console.log(
      `✅ Created/updated ${countries.length} countries successfully!`
    );
  } catch (error) {
    console.error("❌ Error seeding countries:", error);
    throw error;
  }
}

// Run directly if executed
if (require.main === module) {
  seedCountries()
    .catch((e) => {
      console.error(e);
      process.exit(1);
    })
    .finally(async () => {
      await prisma.$disconnect();
    });
}

export { seedCountries };
