import { PrismaClient } from '@prisma/client';

const prisma = new PrismaClient();

async function main() {
    console.log('Starting category data migration...');

    const categories = await prisma.category.findMany();

    console.log(`Found ${categories.length} categories to migrate.`);

    let updatedCount = 0;

    for (const category of categories) {
        // Only update if name_en is missing and name exists
        if (!category.name_en && category.name) {
            await prisma.category.update({
                where: { id: category.id },
                data: {
                    name_en: category.name,
                    description_en: category.description || '',
                },
            });
            updatedCount++;
        }
    }

    console.log(`Migration complete. Updated ${updatedCount} categories.`);
}

main()
    .catch((e) => {
        console.error(e);
        process.exit(1);
    })
    .finally(async () => {
        await prisma.$disconnect();
    });
