import { NextResponse } from "next/server";
import { prisma } from "@/lib/prisma";

function transformCountry(country: any) {
  return {
    id: country.id,
    name: country.name,
    code: country.code,
    domain: country.domain,
    languages: JSON.parse(country.languages || "[]"),
    defaultLanguage: country.defaultLanguage,
    currency: country.currency,
    currencySymbol: country.currencySymbol,
    packagePrice: country.packagePrice,
    paymentGateways: JSON.parse(country.paymentGateways || "[]"),
    isActive: country.isActive,
    createdAt: country.createdAt.toISOString(),
    updatedAt: country.updatedAt.toISOString(),
    customerPhone:country?.customerPhone,
    location_en: country.location_en,
    location_fr: country.location_fr,
    location_de: country.location_de,
    location_it: country.location_it,
    location_pt: country.location_pt,
    location_es: country.location_es,

    sublocation_en: country.sublocation_en,
    sublocation_fr: country.sublocation_fr,
    sublocation_de: country.sublocation_de,
    sublocation_it: country.sublocation_it,
    sublocation_pt: country.sublocation_pt,
    sublocation_es: country.sublocation_es,

    shortDescription_en: country.shortDescription_en,
    shortDescription_fr: country.shortDescription_fr,
    shortDescription_de: country.shortDescription_de,
    shortDescription_it: country.shortDescription_it,
    shortDescription_pt: country.shortDescription_pt,
    shortDescription_es: country.shortDescription_es,

    mapIframe: country.mapIframe,

    logoFooter: country.logoFooter,
    logoHeader: country.logoHeader,
    businessEmail: country.businessEmail,
    supportEmail: country.supportEmail,

    facebookUrl: country.facebookUrl,
    googleUrl: country.googleUrl,
    instagramUrl: country.instagramUrl,
    linkedinUrl: country.linkedinUrl,
    twitterUrl: country.twitterUrl,
    gapIframe: country.gapIframe,
  };
}

export async function GET(req: Request) {
  try {
    const { searchParams } = new URL(req.url);
    const id = searchParams.get("id");

    // ===========================
    //  🔍 Return specific country by ID ONLY
    // ===========================
    if (id) {
      const country = await prisma.country.findUnique({
        where: { id }, // <-- your id = "switzerland", so this must match your DB
      });

      if (!country) {
        return NextResponse.json(
          { error: "Country not found" },
          { status: 404 }
        );
      }

      return NextResponse.json(transformCountry(country));
    }

    // If id is not passed, return empty (or you can remove this)
    return NextResponse.json(
      { error: "ID is required" },
      { status: 400 }
    );

  } catch (error) {
    console.error("Error fetching country:", error);
    return NextResponse.json(
      { error: "Internal server error" },
      { status: 500 }
    );
  }
}
