import { NextRequest, NextResponse } from 'next/server';
import { getServerSession } from 'next-auth';
import { authOptions } from '@/lib/auth';
import { prisma } from '@/lib/prisma';
import { stripe, cancelSubscription} from '@/lib/stripe';


export async function POST(req: Request) {
  try {
    const { subscriptionId } = await req.json();
    const canceled = await cancelSubscription( subscriptionId);
      if (canceled.cancel_at_period_end && subscriptionId) {
         await prisma.categorySubscription.updateMany({
              where: { subscriptionId: subscriptionId },
              data: { subscriptionStatusPayment: "INACTIVE"},
            });
      }

    return NextResponse.json(canceled);
  } catch (error: any) {
    return NextResponse.json({ error: error.message }, { status: 500 });
  }
}
