import { NextRequest, NextResponse } from 'next/server';
import { getServerSession } from 'next-auth';
import { authOptions } from '@/lib/auth';

export async function GET(req: NextRequest) {
  try {
    const session = await getServerSession(authOptions);
    
    if (!session?.user?.email) {
      return NextResponse.json(
        { error: 'Unauthorized' },
        { status: 401 }
      );
    }

    // TODO: Add MembershipCategory model to schema  
    // Return mock data for now
    return NextResponse.json({
      success: true,
      data: []
    });

  } catch (error) {
    console.error('Error fetching membership categories:', error);
    return NextResponse.json(
      { 
        error: error instanceof Error ? error.message : 'Failed to fetch membership categories',
        type: 'server_error'
      },
      { status: 500 }
    );
  }
}