// import { NextRequest, NextResponse } from 'next/server';
// import axios from 'axios';

// export async function POST(req: NextRequest) {
//   try {
//     const { amount, currency, description } = await req.json();

//     // Replace this with your PSP API endpoint for TWINT
//     const response = await axios.post(
//       // 'https://your-psp-provider.com/api/twint/payment',
//      //  'https://6gm2jfe3.api.sandbox.checkout.com/api/twint/payment',
//      // https://api.checkout.com/payments // live api
//      'https://api.sandbox.checkout.com/payments',
//       {
//         "source": {
//           "type": "twint"
//         },
//         // "amount": 6540, 
//         amount: Math.round(50 * 100), 
//         "currency": "CHF",
//         //"merchant_category_code": "5734",
//         "reference": "ORD-5023-4E89",
//        // "capture": true,
//        "merchant_category_code": "5815",
//         "success_url": "https://attendance.activeflowapp.com/payment/success",
//         "cancel_url": "https://attendance.activeflowapp.com/payment/success",
//         "failure_url": "https://attendance.activeflowapp.com/payment/success",
//         "processing_channel_id": "pc_hcpnircyf3eetp2smo443buama",
        
//       },
//       {
//         headers: {
//           Authorization: `Bearer sk_sbox_fzb5smjegmgsdpbygzcg7vbwlyq`,
//           'Content-Type': 'application/json',
//         },
//       }
//     );

//     const { checkoutUrl, paymentId } = response.data;

//     // You could store paymentId in a DB here

//     return NextResponse.json({ checkoutUrl, paymentId });
//   } catch (error: any) {
//     console.error('++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++:', error.response?.data || error.message);
//     return NextResponse.json({ error: 'Failed to create payment' }, { status: 500 });
//   }
// }



// app/api/payment/route.ts

import { NextRequest, NextResponse } from 'next/server';
import axios from 'axios';

// IMPORTANT: Replace these with your actual keys and IDs
const CHECKOUT_SECRET_KEY = process.env.CHECKOUT_SECRET_KEY || 'sk_sbox_fzb5smjegmgsdpbygzcg7vbwlyq';
const PROCESSING_CHANNEL_ID = process.env.PROCESSING_CHANNEL_ID || 'pc_hcpnircyf3eetp2smo443buama';
// NOTE: Use a confirmed, correct MCC. '5815' is a common placeholder, but confirm with Checkout.com.
const MERCHANT_CATEGORY_CODE = '5651';

// Define the API endpoint URL for sandbox payments
// const CHECKOUT_API_URL = 'https://api.sandbox.checkout.com/payments';
const CHECKOUT_API_URL = 'https://7353dc6n.api.sandbox.checkout.com/payments';

export async function POST(req: NextRequest) {
  try {
    // 1. Get payment details from the client request
    const { 
        amount,          // e.g., 6540 (which is 65.40 CHF)
        currency,        // e.g., "CHF" (TWINT is usually CHF)
        reference,       // e.g., "ORD-5023-4E89"
    } = await req.json();

    if (!amount || !currency ) {
      return NextResponse.json({ error: 'Missing required payment details (amount, currency, or reference)' }, { status: 400 });
    }

    // 2. Construct the payment request body
    const paymentBody = {
      "source": {
        "type": "twint"
      },
      "amount": amount,
      "currency": currency,
      "reference": `ORD-${Date.now()}`,
      // The Checkout.com API requires the MCC for certain payment methods like TWINT
      // "merchant_category_code": MERCHANT_CATEGORY_CODE,
      "processing_channel_id": PROCESSING_CHANNEL_ID,
      
      // URLs for redirection after payment completion/cancellation
      "success_url": "https://www.exampleurl.com/success",
      "cancel_url": "https://www.exampleurl.com/success",
      "failure_url": "https://www.exampleurl.com/success",

      "processing": {
              "merchant_category_code": "5815",
        },
    };

    // 3. Make the secure API call to Checkout.com
    const response = await axios.post(
      CHECKOUT_API_URL,
      paymentBody,
      {
        headers: {
          Authorization: `Bearer ${CHECKOUT_SECRET_KEY}`,
          'Content-Type': 'application/json',
        },
      }
    );

    // 4. Extract the payment link (redirection URL)
    const paymentId = response.data.id;
    // For TWINT, the redirection URL is typically found in the _links object
    const checkoutUrl = response.data._links?.redirect?.href; 

    if (!checkoutUrl) {
        // This is a critical check for ensuring the payment link was created
        console.error('Checkout URL not found in API response ___________________________________:', response.data);
        return NextResponse.json({ error: 'Failed to retrieve TWINT redirect URL.' }, { status: 500 });
    }

    // 5. Send the payment link back to the client
    return NextResponse.json({ checkoutUrl, paymentId });

  } catch (error: any) {
    // Log the detailed error from the API for debugging
    const apiError = error.response?.data || error.message;
    console.error('Checkout API Error +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++:', apiError);
    
    // Check for the specific MCC error and provide a helpful message
    if (apiError.error_codes?.includes('merchant_category_code_required')) {
        return NextResponse.json(
            { error: 'Payment failed: Merchant Category Code (MCC) is required or invalid. Please check the MCC and Processing Channel ID configuration.', details: apiError }, 
            { status: 500 }
        );
    }
    
    return NextResponse.json({ error: 'Failed to create payment link', details: apiError }, { status: 500 });
  }
}