import { NextRequest, NextResponse } from 'next/server';

export async function POST(req: NextRequest) {
  try {
    const data = await req.json();

    const { paymentId, status } = data;

    // Validate the webhook signature if required by PSP
    if (status === 'PAID') {
      // ✅ Mark order/payment as paid in your database
      console.log(`Payment ${paymentId} marked as PAID`);
    } else {
      console.log(`Payment ${paymentId} has status: ${status}`);
    }

    return NextResponse.json({ received: true });
  } catch (error) {
    console.error('Webhook error:', error);
    return NextResponse.json({ error: 'Webhook handling failed' }, { status: 400 });
  }
}
