"use client";

import { useEffect  } from "react";
import { getCountryById, getDomainRedirectUrlUserIsLogin } from "@/lib/countries";
import { useSession, signOut} from "next-auth/react";
import { usePathname } from "next/navigation";
import { useToast } from '@/components/ui/ToastContext';

export default function CountryDomainRedirect() {
  const { data: session, status } = useSession();
  const { showWarning } = useToast();
  const pathname = usePathname();
  useEffect(() => {
     const other_country_url = localStorage.getItem("other_country_url");
     localStorage.removeItem("other_country_url");
    if(other_country_url){
        showWarning(`Your account is registered in this domain. We’re redirecting you to your country’s website. Please log in there.`);
        setTimeout(() => {
          window.location.replace(other_country_url);
        }, 2500);
    }     

    const handleRedirect = async () => {
        if (status !== "authenticated" || !session?.user?.countryId) return;
        const countryId = session?.user?.countryId;
        const userCountry = getCountryById(countryId);
        if (!userCountry) return;
        const domainData: any = getDomainRedirectUrlUserIsLogin(userCountry);
            // only HIPL servers
          if(domainData?.domainName !=  userCountry?.domain){
              if(domainData?.domainName != "localhost" && domainData?.domainName !=  "101.53.148.252"){
                 // await signOut({ redirect: false }); 
                  // await signOut({ callbackUrl: '/', });  // uncomment ++++++++++++
              }
              if(domainData?.domainName == "localhost" || domainData?.domainName ==  "101.53.148.252") return;
              //   localStorage.setItem("other_country_url", domainData?.domainUrl);    // uncomment ++++++++++++          
          }
      };
       handleRedirect();   
  }, [status, session, pathname]);
  return null;
}





 
 