"use client";

import { SessionProvider } from "next-auth/react";
import { ReactNode } from "react";
import { ToastProvider } from "./ui/ToastContext";
import ToastContainer from "./ui/ToastContainer";
import ClientToasterBridge from "./ClientToasterBridge";
import CountryDomainRedirect from "./CountryDomainRedirect";

interface ProvidersProps {
  children: ReactNode;
}

export default function Providers({ children }: ProvidersProps) {
  return (
    <SessionProvider>
      <ToastProvider>
        {children}
        <ToastContainer />
        <CountryDomainRedirect />
        <ClientToasterBridge />
      </ToastProvider>
    </SessionProvider>
  );
}
