"use client";

import { useCountry } from "@/context/domainContext";
interface ContactUsContentProps {
  locale: string;
}
export default function ContactUsContent({ locale }: ContactUsContentProps) {
  const { country } = useCountry();

  if (!country) return null;
  const currentLang = locale || country.defaultLanguage;
  const location = country[`location_${currentLang}`];
  const sublocation = country[`sublocation_${currentLang}`];

  return (
    <>
      <link rel="stylesheet" href="/assets/css/contact.css" />

      {/* Hero Section */}
      <section className="inner-hero-wrapper">
        <div className="container">
          <div className="row">
            <div className="col-12 col-md-7 col-lg-8 align-self-center">
              <div className="hero-content">
                <h1>Contact Us</h1>
                <p>We’re here to help — anytime you need us.</p>
              </div>
            </div>
            <div className="col-12 col-md-5 col-lg-4 align-self-end">
              <div className="inner-hero-img text-center pt-3">
                <img src="/assets/image/contact-us.svg" alt="contact-us" />
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* Contact Section */}
      <section className="contact-wrapper py-60">
        <div className="container">
          <div className="row">
            <div className="col-12">
              <div className="heading-box">
                <h2>We're always here to assist.</h2>
                <p>
                  Have a question, need support, or just want to get in touch?
                  Our team is always ready to assist you.
                </p>
              </div>
            </div>

            {/* Contact Cards */}
            <div className="col-sm-12 col-md-6 col-lg-5">
              <div>

                {/* Support Email */}
                <div className="contact-card">
                  <div className="contact-text">
                    <div className="contact-label">For General Support</div>
                    <div className="contact-detail">{country?.supportEmail}</div>
                  </div>
                  <a
                    href={`mailto:${country?.supportEmail}`}
                    className="download-arrow stretched-link"
                  >
                    ➜
                  </a>
                </div>

                {/* Business Email */}
                <div className="contact-card">
                  <div className="contact-text">
                    <div className="contact-label">Business / Partnerships</div>
                    <div className="contact-detail">{country?.businessEmail}</div>
                  </div>
                  <a
                    href={`mailto:${country?.businessEmail}`}
                    className="download-arrow stretched-link"
                  >
                    ➜
                  </a>
                </div>

                {/* Phone */}
                <div className="contact-card">
                  <div className="contact-text">
                    <div className="contact-label"> For Customer Support</div>
                    <div className="contact-detail">{country?.customerPhone}</div>
                  </div>
                  <a
                    href='/'
                    className="download-arrow stretched-link"
                  >
                    ➜
                  </a>
                </div>

              </div>
            </div>

            {/* Map */}
            <div className="col-sm-12 col-md-6 col-lg-7">
              <div className="contact-location">
                <div className="contact-map">
                  <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2701.8329028041794!2d8.537194576689535!3d47.37617970386029!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x47900a062ef36881%3A0xba2862db8cf7a41!2sBahnhofstrasse%20100%2C%208001%20Z%C3%BCrich%2C%20Switzerland!5e0!3m2!1sen!2sin!4v1751281564242!5m2!1sen!2sin" width="100%" height="312" loading="lazy"></iframe>
                </div>
                <div className="contact-map-detail">
                  <div className="contact-d-top">
                    <label>Our Location</label>
                    <div>Smile24 {location} Office</div>
                  </div>
                  <div className="contact-d-bottom">
                  {sublocation}
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </>
  );
}
