'use client';

import Link from 'next/link';

interface ProjectDetailsButtonProps {
  projectId: string;
  locale: string;
  userRole: 'freelancer' | 'client';
  className?: string;
  children?: React.ReactNode;
}

export default function ProjectDetailsButton({ 
  projectId, 
  locale, 
  userRole,
  className = "btn btn-outline-primary btn-sm",
  children = "View Details"
}: ProjectDetailsButtonProps) {
  const detailsUrl = `/${locale}/${userRole}/project-details/${projectId}`;

  return (
    <Link 
      href={detailsUrl}
      className={className}
    >
      {children}
    </Link>
  );
}