'use client';

import Link from 'next/link';

interface UpdateProposalButtonProps {
  projectId: string;
  locale: string;
  projectStatus?: string;
  bidStatus?: string;
  className?: string;
  children?: React.ReactNode;
}

export default function UpdateProposalButton({ 
  projectId, 
  locale, 
  projectStatus = 'active',
  bidStatus = 'pending',
  className = "btn btn-outline-primary btn-sm",
  children = "Update Proposal"
}: UpdateProposalButtonProps) {
  
  // Only show button for active projects with pending or accepted bids
  const canUpdate = projectStatus === 'active' && (bidStatus === 'pending' || bidStatus === 'accepted');

  if (!canUpdate) {
    return null;
  }

  const updateUrl = `/[locale]/freelancer/project-details/${projectId}`;

  return (
    <Link 
      href={updateUrl.replace('[locale]', locale)}
      className={className}
    >
      {children}
    </Link>
  );
}