'use client';

import Link from 'next/link';
import { useSession } from 'next-auth/react';

interface ReviewButtonProps {
  projectId: string;
  projectStatus: string;
  locale: string;
  userRole: 'freelancer' | 'client';
  className?: string;
}

export default function ReviewButton({ 
  projectId, 
  projectStatus, 
  locale, 
  userRole,
  className = "btn btn-primary btn-sm"
}: ReviewButtonProps) {
  const { data: session } = useSession();

  // Only show review button for completed projects
  if (projectStatus !== 'completed') {
    return null;
  }

  // Don't show if user is not authenticated
  if (!session) {
    return null;
  }

  const reviewUrl = `/${locale}/${userRole}/review/${projectId}`;

  return (
    <Link 
      href={reviewUrl}
      className={className}
    >
      Write Review
    </Link>
  );
}