"use client";
import React from "react";
import Link from "next/link";
import { getCountryDataByDomain } from "@/lib/countries";
import { useTranslations } from "next-intl";
import Image from 'next/image';

const HomeBanner = ({ locale }: any) => {
  const datacounter = getCountryDataByDomain();
  const t = useTranslations();

  return (
    <>
      <section className="hero-wrapper position-relative pt-80">
        <div className="bg-shap">
          <Image src="/assets/image/banner-shap.webp" alt="shape" width={1920} height={200} priority />
        </div>
        <div className="container z-2">
          <div className="row">
            <div className="col-12 col-md-12">
              <div className="hero-content">
                <h1>
                  <span className="primary-color">
                    {t("home.post_project")}
                  </span>{" "}
                  {t("home.banner.for_free")}{" "}
                  <span className="secondary-text">
                    {t("home.banner.talent")}
                  </span>{" "}
                  {t("home.banner.in_min")}
                </h1>
                <p>{t("home.banner.description")}</p>
                <div className="button-group d-flex justify-content-center">
                  <Link
                    href={`/${locale}/client/post-project`}
                    className="custom-btn primary-fill rounded-pill btn-lg"
                  >
                    {t("home.post_project")}
                  </Link>
                  <Link
                    href={`/${locale}/freelancers`}
                    className="custom-btn secondary-outline rounded-pill btn-lg"
                  >
                    {t("home.hire_freelancer")}
                  </Link>
                </div>
              </div>
            </div>
          </div>
          <div className="row">
            <div className="col-12 col-md-12">
              <div className="w-100 position-relative hero-image-outer">
                <div className="animi-card an-1">
                  <Image src="/assets/image/home/proofilecard3.svg" className="img-fluid" alt="proofilecard1" width={220} height={193} priority />
                  <div className="animi-chat02 animi-chat">
                    <div className="content">
                      <h5>
                        {t("home.post_banner_one")} <br />
                        {t("home.post_banner_two")} {datacounter?.currencySymbol} 50....
                        <span>3 {t("home.post_banner_three")}</span>
                      </h5>
                    </div>
                  </div>
                </div>
                <div className="animi-card an-2">
                  <Image src="/assets/image/home/proofilecard1.svg" className="img-fluid" alt="proofilecard1" width={220} height={193} priority />
                  <div className="animi-chat03 animi-chat">
                    <div className="content">
                      <h5>
                        {t("home.post_banner_five")}
                        <br />
                        {t("home.post_banner_for")} {datacounter?.currencySymbol} 10....
                        <span>3 {t("home.post_banner_three")}</span>
                      </h5>
                    </div>
                  </div>
                </div>
                <div className="animi-card an-3">
                  <Image src="/assets/image/home/proofilecard2.svg" className="img-fluid" alt="proofilecard2" width={220} height={193} priority />
                  <div className="animi-chat03 animi-chat">
                    <div className="content">
                      <h5>
                        {t("home.post_banner_five")}
                        <br />
                        {t("home.post_banner_for")} {datacounter?.currencySymbol} 10....
                        <span>3 {t("home.post_banner_three")}</span>
                      </h5>
                    </div>
                  </div>
                </div>
                <div className="hero-image">
                  <div className="user-img">
                    <Image src="/assets/image/heroimg01.webp" className="img-fluid" alt="heroimg01" width={407} height={590} priority />
                  </div>
                  <div className="animi-icon icon-1">
                    <Image src="/assets/image/home/plan-1.svg" className="img-fluid" alt="plan-1" width={110} height={60} />
                  </div>
                  <div className="animi-icon icon-2">
                    <Image src="/assets/image/home/plan-2.svg" className="img-fluid" alt="plan-2" width={92} height={94} />
                  </div>
                  <div className="animi-icon icon-3">
                    <Image src="/assets/image/home/plan-3.svg" className="img-fluid" alt="plan-3" width={121} height={85} />
                  </div>
                  <div className="animi-chat01 animi-chat aniamtion-key-1">
                    <div className="icon">
                      <Image src="/assets/image/animichat03.png" className="img-fluid" alt="animichat03" width={44} height={44} />
                    </div>
                    <div className="content">
                      <h5>{t("home.post_project")} </h5>
                      <span>5 {t("home.post_banner_three")}</span>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

      <style jsx>{`
          .secondary-text {
              color: var(--typo-primary);
          }

          .z-2 {
              position: relative;
              z-index: 2;
          }

          .hero-wrapper {
              background-image: url(/assets/image/banner-bg.svg);
              background-repeat: no-repeat;
              background-position: center;
              background-size: cover;
          }

          .hero-content {
              text-align: center;
              max-width: 1050px;
              margin: auto;
          }

          .hero-wrapper h1 {
              font-size: 50px;
              line-height: 120%;
              text-align: center;
              font-weight: 800;
              margin-bottom: 20px;
          }

          .hero-wrapper .hero-content p {
              font-size: var(--font-20);
              max-width: 669px;
              margin: 0 auto;
          }

          .hero-wrapper .hero-content .button-group {
              display: flex;
              align-items: center;
              gap: 20px;
              margin-top: 32px;
          }

          .hero-image-outer {
              padding-top: 32px;
              position: relative;
          }

          .hero-image {
              position: relative;
              max-width: 407px;
              margin: 0 auto;
          }

          .hero-image .user-img img{
              width: auto !important;
              height: auto !important;
          }

          .icon-1 {
              left: -110px;
              top: 10%;
          }

          .icon-2 {
              left: -70px;
              top: 43%;
          }

          .icon-3 {
              right: -110px;
              top: 25%;
          }

          .animi-icon {
              position: absolute;
          }

          .animi-chat {
              display: flex;
              position: absolute;
              top: 0;
              gap: 10px;
              background-color: var(--color-white);
              padding: 7px;
              max-width: 250px;
              border-radius: 50px;
              box-shadow: rgba(149, 157, 165, 0.2) 0px 8px 24px;
          }

          .animi-chat::after {
              content: "";
              display: block;
              border-left: 10px solid transparent;
              border-right: 10px solid transparent;
              transition: all 0.5s ease-in-out;
              transform: translateY(10px);
              border-bottom: 6px solid var(--color-white);
              position: absolute;
              bottom: -5px;
              left: 30px;
              transform: rotate(180deg);
          }

          .animi-chat .content {
              padding: 0 10px;
          }

          .animi-chat .content h5 {
              font-size: 12px;
              margin: 0;
              position: relative;
              line-height: 18px;
              min-width: 130px;
          }

          .animi-chat img {
              width: 50px;
              height: 50px;
              border-radius: 50%;
          }

          .animi-chat .content span {
              position: absolute;
              bottom: 0;
              right: 0;
              font-size: 7px;
              color: var(--typo-primary);
              white-space: nowrap;
          }

          .animi-card {
              position: absolute;
              max-width: 260px;
          }

          .an-1 {
              top: -49px;
          }

          .an-2 {
              left: 10%;
              bottom: 15%;
          }

          .an-3 {
              right: 0;
              top: 15%;
          }

          .animi-chat01.animi-chat {
              top: 46%;
              left: 25%;
          }

          .hero-image .icon {
              height: 44px;
              width: 44px;
              min-width: 44px;
          }

          .hero-image .icon img {
              height: 100%;
              width: 100%;
              object-fit: cover;
          }

          .hero-image .animi-chat {
              align-items: center;
          }

          .hero-image .animi-chat .content {
              padding: 0 10px 0 0;
              display: flex;
              flex-direction: column;
              justify-content: center;
          }

          .hero-image .animi-chat:after {
              left: 50%;
          }

          .hero-image .animi-chat .content h5 {
              min-width: auto;
          }

          .hero-image .animi-chat .content span {
              position: initial;
              line-height: normal;
          }

          .animi-chat03.animi-chat {
              bottom: 100%;
              top: auto;
              left: 0;
          }

          .animi-chat02.animi-chat {
              left: 0px;
              top: auto;
              bottom: -10px;
          }

          .animi-chat02.animi-chat::after {
              bottom: auto;
              top: -5px;
              left: 30px;
              border-bottom: none;
              border-top: 6px solid var(--color-white);
          }

          .animi-chat01 {
              animation-name: animation-1;
              animation-duration: 4s;
              animation-iteration-count: infinite;
              animation-direction: alternate;
          }

          @keyframes animation-1 {
              0% {
                  transform: translateY(0);
              }

              100% {
                  transform: translateY(30px);
              }
          }

          .animi-chat03,
          .animi-chat02 {
              animation-name: animation-2;
              animation-duration: 3s;
              animation-iteration-count: infinite;
              animation-direction: alternate;
          }

          @keyframes animation-2 {
              0% {
                  transform: translateX(0);
              }

              100% {
                  transform: translateX(20px);
              }
          }

          .custom-btn.btn-lg {
              font-size: var(--font-large);
              padding: 14px 40px;
              font-weight: 700;
          }
          .primary-outline:hover, .primary-fill {
              background-color: var(--color-primary) !important;
              color: var(--color-white) !important;
              border-color: var(--color-primary) !important;
          }
          .custom-btn {
              display: flex;
              align-items: center;
              justify-content: center;
              gap: 8px;
              border: 1px solid;
              padding: 7px 16px;
              cursor: pointer;
              font-size: var(--font-regular);
              line-height: 24px;
              border-radius: 4px;
              text-transform: capitalize;
              width: auto !important;
          }

          .hero-image .user-img img {
              width: auto !important;
              height: auto !important;
          }

          a {
              text-decoration: none !important;
              color: var(--color-primary);
          }

        @media(max-width:1200px) {

            .an-2 {
                left: 10%;
                bottom: 7%;
            }

            /* banner */
            .hero-image {
                max-width: 250px;
            }

            .hero-wrapper h1 {
                font-size: var(--font-40);
                line-height: 50px;
            }

            .hero-wrapper .hero-content p {
                font-size: var(--font-regular);
                max-width: 540px;
            }

            .animi-chat02.animi-chat {
                left: 32px;
                top: auto;
                bottom: 16px;
            }

            .animi-chat03.animi-chat {
                bottom: 97%;
                left: 46px;
            }

            .icon-3 {
                right: -50px;
            }

            .icon-2 {
                left: -40px;
                top: 30%;
            }

            /* category */
            .category-list-wrap {
                grid-template-columns: 1fr 1fr 1fr;
                gap: 24px;
            }

            /* hiring */
            .hiring-inner .content {
                width: 100%;
                max-width: 490px;
            }

            /* project-step */
            .project-step-wrapper .head-content {
                margin-bottom: 0;
            }

            .post-project-btn {
                margin-top: 40px;
            }

            .step-item::before {
                left: 15px;
                font-size: 24px;
            }

            .project-step {
                gap: 24px;
            }

            .project-step .step-item {
                padding: 40px 15px 20px;
                width: calc(25% - 18px);
            }

            .project-step .step-item .step-img {
                height: 142px;
                margin: 0 0 20px;
            }

            .step-item .step-content h4 {
                font-size: var(--font-regular);
                line-height: 24px;
                margin-bottom: 7px;
            }

            .project-step .step-item:nth-child(2n) {
                margin-top: 48px;
            }

            /* feedback */
            .feedback-icon {
                width: 75px;
                min-width: 75px;
                height: 75px;
                border-radius: 8px;
            }

            .feedback-icon img {
                max-width: 35px;
                max-height: 35px;
            }

            .feedback-content {
                padding-left: 15px;
            }

            .feedback-item h3 {
                font-size: var(--font-25);
                margin-bottom: 5px;
            }

            /* benift */
            .benift-list ul li .list-item {
                padding: 15px;
                margin-bottom: 15px;
            }

            .benift-list ul li .list-item .icon-box {
                width: 57px;
                min-width: 57px;
                height: 63px;
            }

            /* cta */
            .cta-center {
                padding: 50px 15px;
            }

            /* freelancers */
            .freelancers-wrapper {
                background-size: auto, 75%;
            }

            .freelancers-content .heading-box p {
                font-size: var(--font-regular);
            }

            .freelancers-list {
                gap: 20px;
            }

            .freelancers-list .list-item .icon-box {
                width: 60px;
                min-width: 60px;
                height: 60px;
            }

            .freelancers-list .list-item .icon-box img {
                max-width: 24px;
            }

            .freelancers-list .list-item h5 {
                margin-bottom: 4px;
            }

            .freelancers-list .list-item p {
                max-width: 100%;
            }

            /* testimonial */
            .testimonial-sec {
                background-size: contain;
            }

            .testimonial-card {
                padding: 20px 15px;
            }
        }

@media(max-width:1024px) {
    .hero-wrapper h1 {
        font-size: var(--font-32);
        line-height: 42px;
    }

    .hero-image-outer {
        padding-top: 22px;
    }

    .hero-image-outer .animi-card,
    .hero-image-outer .animi-icon {
        display: none;
    }

    .animi-chat {
        zoom: .7;
    }

    /*  */

    .category-list-wrap li a {
        font-size: var(--font-regular);
    }

    /*  */
    .project-step-wrapper {
        background-size: contain;
    }

    /*  */
    .hiring-inner .content p {
        font-size: var(--font-small);
    }

    .heading-box .h-link a {
        font-size: var(--font-small);
    }

    .heading-box .h-link a svg {
        width: 20px;
        height: 20px;
    }

    .hero-wrapper .hero-content .button-group {
        margin-top: 24px;
    }
}

@media(max-width:991px) {
    .feedback-item {
        flex-direction: column;
        text-align: center;
    }

    .feedback-content {
        padding-left: 0;
        padding-top: 15px;
    }

    .feedback-item h3 {
        justify-content: center;
    }
}

@media(max-width:767px) {
    .review-content {
        padding: 20px 15px;
    }

    .button-group {
        flex-wrap: wrap;
    }

    .hiring-inner {
        padding: 30px 20px;
        background: linear-gradient(268.27deg, #001818 0.72%, #064848 99.41%);
        background-size: cover;
        background-position: center;
    }

    .hero-image {
        max-width: 240px;
    }

    /* project-step */
    .project-step .step-item {
        padding: 40px 15px 20px;
        width: calc(50% - 12px);
    }

    .project-step .step-item:nth-child(2n) {
        margin-top: 0;
    }

    .project-step {
        align-items: initial;
    }

    /*  */
    .cta-center {
        padding: 40px 15px;
    }

    /* freelancers */
    .freelancers-content {
        padding: 70px 0 0;
    }

    .freelancers-wrapper {
        background-size: auto, 100%;
    }

    .freelancers-img-wrapper {
        max-width: 320px;
        margin: auto;
    }

    /*  */
    .feedback-item {
        margin-bottom: 30px;
    }

    /*  */
    .form-group {
        flex-wrap: wrap;
    }


}

@media(max-width:580px) {
    .category-list-wrap {
        grid-template-columns: 1fr 1fr;
        gap: 20px;
    }

    .category-list-wrap li {
        box-shadow: 0px 4px 12px 0px #0000000a;
        padding: 15px;
    }

    .category-list-wrap li .cat-img {
        width: 45px;
        height: 45px;
    }

    .category-list-wrap li a {
        font-size: var(--font-small);
        font-weight: 700;
        line-height: normal;
    }

    .project-step .step-item {
        width: 100%;
    }

    .hero-image {
        max-width: 200px;
    }

    .animi-chat01.animi-chat {
        top: 37%;
        left: 15%;
    }

    .custom-btn.btn-lg{
        padding: 10px 15px;
        font-size: 15px;
        line-height: normal;
    }
}

@media(max-width:480px) {
    .category-list-wrap {
        gap: 10px;
    }
}

      `}</style>
    </>
  );
};

export default HomeBanner;
