
"use client";

import React, { useEffect, useRef, useState } from "react";
import {
  FacebookShareButton,
  TwitterShareButton,
  LinkedinShareButton,
  WhatsappShareButton,
  TelegramShareButton,
  EmailShareButton,
  InstapaperShareButton,
  FacebookIcon,
  TwitterIcon,
  LinkedinIcon,
  WhatsappIcon,
  TelegramIcon,
  EmailIcon,
  InstapaperIcon,
} from "react-share";
import "./shareButton.css";
interface ShareProjectButtonProps {
  project: any;
  locale: string;
}

const ShareProjectButton: React.FC<ShareProjectButtonProps> = ({
  project,
  locale,
}) => {
  const [showOptions, setShowOptions] = useState(false);
  const [showIcons, setShowIcons] = useState(false);
  const fallbackUrl = typeof window !== "undefined" ? window.location.href : "";
  const wrapperRef = useRef<HTMLDivElement>(null);
  const stripHTML = (html: string = "") => {
  if (!html) return "";
  const temp = document.createElement("div");
  temp.innerHTML = html;
  return temp.textContent || temp.innerText || "";
};

    // CLICK OUTSIDE TO CLOSE
  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (
        wrapperRef.current &&
        !wrapperRef.current.contains(event.target as Node)
      ) {
        setShowOptions(false);
        setShowIcons(false);
      }
    }

    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);
  const projectUrl = project?.id
    ? `${window.location.origin}/${locale}/projects/${project?.id}`
    : fallbackUrl;

const safeTitle =
  typeof project?.title === "string" && project?.title.trim().length > 0
    ? project?.title
    : null;

 const url = `${window.location.origin}`;
const plainDescription = stripHTML(project?.description);

const safeDescription =
  typeof plainDescription === "string" && plainDescription.trim().length > 0
    ? plainDescription.trim()
    : null;

  const shareText = safeTitle
    ? `Check out this project: ${safeTitle}\n\nDescription: ${safeDescription}\n\n${url}`
    : `Check this out!\n${url}`;

  const handleNativeShare = () => {
    if (navigator.share) {
      navigator
        .share({
          title: project?.title ?? "Project",
          text: shareText,
          url: projectUrl,
        })
        .catch(console.error);
    } else {
      navigator.clipboard.writeText(projectUrl);
      alert("Link copied to clipboard!");
    }
  };

  return (
    <div className="relative">
      <button
        onClick={() => setShowOptions((prev) => !prev)}
        className="share-profile"
        title="Share this project"
      >
        <svg
          width="21"
          height="21"
          viewBox="0 0 21 21"
          fill="none"
          xmlns="http://www.w3.org/2000/svg"
        >
          <path
            d="M15.5 13.8993C14.8667 13.8993 14.3 14.1494 13.8667 14.541L7.925 11.0827C7.96667 10.891 8 10.6993 8 10.4993C8 10.2993 7.96667 10.1077 7.925 9.91602L13.8 6.49102C14.25 6.90768 14.8417 7.16602 15.5 7.16602C16.8833 7.16602 18 6.04935 18 4.66602C18 3.28268 16.8833 2.16602 15.5 2.16602C14.1167 2.16602 13 3.28268 13 4.66602C13 4.86602 13.0333 5.05768 13.075 5.24935L7.2 8.67435C6.75 8.25768 6.15833 7.99935 5.5 7.99935C4.11667 7.99935 3 9.11602 3 10.4993C3 11.8827 4.11667 12.9993 5.5 12.9993C6.15833 12.9993 6.75 12.741 7.2 12.3243L13.1333 15.791C13.0917 15.966 13.0667 16.1493 13.0667 16.3327C13.0667 17.6743 14.1583 18.766 15.5 18.766C16.8417 18.766 17.9333 17.6743 17.9333 16.3327C17.9333 14.991 16.8417 13.8993 15.5 13.8993Z"
            fill="#EF7310"
          />
        </svg>
      </button>
      {showOptions && (
        <div className="share-block-wrap">
          {/* <button
            onClick={handleNativeShare}
            className="flex items-center gap-2 w-full px-4 py-2.5 
               rounded-xl bg-blue-50 hover:bg-blue-100 
               text-blue-700 font-medium transition-all mb-3"
          >
            📱 Share (Native)
          </button>

          <button
            onClick={() => setShowIcons((prev) => !prev)}
            className="flex items-center gap-2 w-full px-4 py-2.5 
               rounded-xl bg-purple-50 hover:bg-purple-100 
               text-purple-700 font-medium transition-all"
          >
            🔗 More Share Options
          </button> */}

            <FacebookShareButton url={projectUrl}>
            <FacebookIcon size={32} round />
          </FacebookShareButton>

          <TwitterShareButton url={projectUrl} title={shareText}>
            <TwitterIcon size={32} round />
          </TwitterShareButton>

          <LinkedinShareButton url={projectUrl}>
            <LinkedinIcon size={32} round />
          </LinkedinShareButton>

          <WhatsappShareButton url={projectUrl} title={shareText}>
            <WhatsappIcon size={32} round />
          </WhatsappShareButton>

          <TelegramShareButton url={projectUrl} title={shareText}>
            <TelegramIcon size={32} round />
          </TelegramShareButton>

          <EmailShareButton
            url={projectUrl}
            subject={project?.title ?? "Project"}
            body={shareText}
          >
            <EmailIcon size={32} round />
          </EmailShareButton>

          <InstapaperShareButton url={projectUrl}>
            <InstapaperIcon size={32} round />
          </InstapaperShareButton>

          {/* <button  onClick={handleNativeShare}
            className="flex items-center gap-2 w-full px-4 py-2.5 
               rounded-xl bg-blue-50 hover:bg-blue-100 
               text-blue-700 font-medium transition-all mb-3"
          >
            📱 Share (Native)
          </button> */}
        </div>
      )}

      {/* {showIcons && (
        <div className="absolute top-28 right-0 bg-white shadow-md p-3 rounded grid grid-cols-4 gap-2 z-50">
          <FacebookShareButton url={projectUrl}>
            <FacebookIcon size={32} round />
          </FacebookShareButton>

          <TwitterShareButton url={projectUrl} title={shareText}>
            <TwitterIcon size={32} round />
          </TwitterShareButton>

          <LinkedinShareButton url={projectUrl}>
            <LinkedinIcon size={32} round />
          </LinkedinShareButton>

          <WhatsappShareButton url={projectUrl} title={shareText}>
            <WhatsappIcon size={32} round />
          </WhatsappShareButton>

          <TelegramShareButton url={projectUrl} title={shareText}>
            <TelegramIcon size={32} round />
          </TelegramShareButton>

          <EmailShareButton
            url={projectUrl}
            subject={project?.title ?? "Project"}
            body={shareText}
          >
            <EmailIcon size={32} round />
          </EmailShareButton>

          <InstapaperShareButton url={projectUrl}>
            <InstapaperIcon size={32} round />
          </InstapaperShareButton>
        </div>
      )} */}
    </div>
  );
};

export default ShareProjectButton;
