"use client";

import { getCountryDataByDomain } from "@/lib/countries";
import axios from "axios";
import {
  createContext,
  useContext,
  useState,
  ReactNode,
  useEffect,
} from "react";

const CountriesContext = createContext<any>(null);

export const CountriesProvider = ({ children }: { children: ReactNode }) => {
  const [country, setCountry] = useState<any>(null);
  const datacounter = getCountryDataByDomain()
  const fetchCountryByDomain = async () => {
    try {
      const res = await axios.get(`/api/domains?id=${datacounter?.id}`);
      setCountry(res.data);
    } catch (err) {
      console.error("Error fetching country by domain:", err);
      setCountry(null);
    }
  };

  useEffect(() => {
    fetchCountryByDomain();
  }, []);

  console.log("222222222222222222222222",country)

  return (
    <CountriesContext.Provider
      value={{ country, setCountry, fetchCountryByDomain }}
    >
      {children}
    </CountriesContext.Provider>
  );
};

export const useCountry = () => {
  const context = useContext(CountriesContext);
  if (!context)
    throw new Error("useCountry must be used within a CountriesProvider");
  return context;
};
