export interface CountryConfig {
  id: string;
  name: string;
  code: string;
  domain: string;
  languages: string[];
  defaultLanguage: string;
  currency: string;
  currencySymbol: string;
  packagePrice: number;
  paymentGateways: string[];
  priceId: string;
}

export const countries: CountryConfig[] = [
  {
    id: 'luxembourg',
    name: 'Luxembourg',
    code: 'LU',
    domain: 'smile24.lu',
    languages: ['fr', 'en'],
    defaultLanguage: 'fr',
    currency: 'EUR',
    currencySymbol: '€',
    packagePrice: 9.90,
    paymentGateways: ['stripe'],
    priceId:"price_1SIjYFPznDOle2DTlErCY1gk"
  },
  {
    id: 'belgium',
    name: 'Belgium',
    code: 'BE',
    domain: 'smile24.be',
    languages: ['fr', 'en'],
    defaultLanguage: 'fr',
    currency: 'EUR',
    currencySymbol: '€',
    packagePrice: 9.90,
    paymentGateways: ['stripe'],
    priceId:"price_1SIjYFPznDOle2DTlErCY1gk"
  },
  {
    id: 'france',
    name: 'France',
    code: 'FR',
    domain: 'smile24.fr',
    languages: ['fr', 'en'],
    defaultLanguage: 'fr',
    currency: 'EUR',
    currencySymbol: '€',
    packagePrice: 9.90,
    paymentGateways: ['stripe'],
    priceId:"price_1SIjYFPznDOle2DTlErCY1gk"
  },
  {
    id: 'switzerland',
    name: 'Switzerland',
    code: 'CH',
    domain: 'smile24.ch',
    languages: ['fr', 'de', 'it'],
    defaultLanguage: 'fr',
    currency: 'CHF',
    currencySymbol: 'CHF',
    packagePrice: 19.90,
    paymentGateways: ['stripe', 'twint'],
    priceId:"price_1SIjZBPznDOle2DTuiSxlxrp"
  },
  {
    id: 'italy',
    name: 'Italy',
    code: 'IT',
    domain: 'smile24.it',
    languages: ['it', 'en'],
    defaultLanguage: 'it',
    currency: 'EUR',
    currencySymbol: '€',
    packagePrice: 9.90,
    paymentGateways: ['stripe'],
    priceId:"price_1SIjYFPznDOle2DTlErCY1gk"
  },
  {
    id: 'uk',
    name: 'United Kingdom',
    code: 'GB',
    domain: 'smile24.uk',
    languages: ['en'],
    defaultLanguage: 'en',
    currency: 'GBP',
    currencySymbol: '£',
    packagePrice: 9.90,
    paymentGateways: ['stripe'],
    priceId:"price_1SIjayPznDOle2DTZtqVYgnq"
  },
  {
    id: 'portugal',
    name: 'Portugal',
    code: 'PT',
    domain: 'smile24.pt',
    languages: ['pt', 'en'],
    defaultLanguage: 'pt',
    currency: 'EUR',
    currencySymbol: '€',
    packagePrice: 9.90,
    paymentGateways: ['stripe'],
    priceId:"price_1SIjYFPznDOle2DTlErCY1gk"
  },
  {
    id: 'spain',
    name: 'Spain',
    code: 'ES',
    domain: 'smile24.es',
    languages: ['es', 'en'],
    defaultLanguage: 'es',
    currency: 'EUR',
    currencySymbol: '€',
    packagePrice: 9.90,
    paymentGateways: ['stripe'],
    priceId:"price_1SIjYFPznDOle2DTlErCY1gk"
  },
  {
    id: 'germany',
    name: 'Germany',
    code: 'DE',
    domain: 'smile77.de',
    languages: ['de', 'en'],
    defaultLanguage: 'de',
    currency: 'EUR',
    currencySymbol: '€',
    packagePrice: 9.90,
    paymentGateways: ['stripe'],
    priceId:"price_1SIjYFPznDOle2DTlErCY1gk"
  },
  {
    id: 'austria',
    name: 'Austria',
    code: 'AT',
    domain: 'smile77.at',
    languages: ['de', 'en'],
    defaultLanguage: 'de',
    currency: 'EUR',
    currencySymbol: '€',
    packagePrice: 9.90,
    paymentGateways: ['stripe'],
    priceId:"price_1SIjYFPznDOle2DTlErCY1gk"
  }
];

export const getCountryById = (id: string) => countries.find(c => c.id === id);
export const getCountryByDomain = (domain: string): CountryConfig | undefined => {
 
  // remove when live project domains set
    if(domain == 'smile24.hipl-staging2.com'){
        domain =  "smile24.ch";
    }else if(domain == 'smile24-france.hipl-staging2.com'){
        domain =  "smile24.fr";
    }else if(domain == 'smile24-uk.hipl-staging2.com'){
        domain =  "smile24.uk";
    }
   // remove when live project domains set
 
 
  return countries.find(country => country.domain === domain);
};

export const getCountryByCode = (code: string): CountryConfig | undefined => {
  return countries.find(country => country.code === code);
};

export const supportedLocales = ['en', 'fr', 'de', 'it', 'pt', 'es'];

export const localeNames: Record<string, string> = {
  en: 'English',
  fr: 'Français',
  de: 'Deutsch',
  it: 'Italiano',
  pt: 'Português',
  es: 'Español'
};

export const getCountryDataByDomain = () => {

  var domainName = window?.location?.hostname ?? '';

  if(domainName == 'localhost' || domainName == "101.53.148.252" || domainName == "frontend-stg.smile24.ch"){
      domainName =  "smile24.ch";
  }else if(domainName == 'smile24.hipl-staging2.com'){
      domainName =  "smile24.ch";
  }else if(domainName == 'smile24-france.hipl-staging2.com'){
      domainName =  "smile24.fr";
  }else if(domainName == 'smile24-uk.hipl-staging2.com'){
      domainName =  "smile24.uk";
  }
  return countries.find(country => country.domain === domainName);
 
   // return countries.find(country => country.domain === domain);
};


export const getCountryIdToDomainLogin = (countryId:any) => {
    const userCountry = getCountryById(countryId);
    var domainUrl = "";
      if(userCountry?.id == "switzerland"){
          // domainUrl = `https://smile24.hipl-staging2.com/${userCountry?.languages[0]}`; // change
          domainUrl = `https://frontend-stg.smile24.ch/${userCountry?.languages[0]}`;
      }else if(userCountry?.id == "france"){
          domainUrl = `https://smile24-france.hipl-staging2.com/${userCountry?.languages[0]}`;
      }else if(userCountry?.id == "uk"){
          domainUrl = `https://smile24-uk.hipl-staging2.com/${userCountry?.languages[0]}`;
      }
      return domainUrl;
};
export const getDomainRedirectUrlUserIsLogin = (userCountry:any):any => {
    var domainName = window?.location?.hostname ?? '';
        if(domainName == "smile24.hipl-staging2.com" || domainName == "frontend-stg.smile24.ch"){
            domainName = "smile24.ch";
        }else if(domainName == "smile24-france.hipl-staging2.com"){
          domainName = "smile24.fr";
        }else if(domainName == "smile24-uk.hipl-staging2.com"){
          domainName ="smile24.uk"
        }

    var domainUrl = "";
      if(userCountry?.domain == 'smile24.ch'){
        //  domainUrl = `https://smile24.hipl-staging2.com/${userCountry?.languages[0]}`; // change
         domainUrl = `https://frontend-stg.smile24.ch/${userCountry?.languages[0]}`;
      }else if(userCountry?.domain == 'smile24.fr'){
        domainUrl = `https://smile24-france.hipl-staging2.com/${userCountry?.languages[0]}`;
      }else if(userCountry?.domain == 'smile24.uk'){
        domainUrl = `https://smile24-uk.hipl-staging2.com/${userCountry?.languages[0]}`;
      }

      return {domainName,domainUrl};
};