import nodemailer from 'nodemailer';

const HOST = process.env.EMAIL_HOST || "sandbox.smtp.mailtrap.io";
const USERNAME = process.env.EMAIL_USER;
const PASSWORD = process.env.EMAIL_PASSWORD;
const PORT = process.env.EMAIL_PORT ? parseInt(process.env.EMAIL_PORT) : 2525;
const EMAIL_FROM = process.env.EMAIL_FROM || "noreply@yourapp.com";



const transporter = nodemailer.createTransport({
    host: HOST,
    port: PORT,
    secure: false, 
    auth: {
        user: USERNAME,
        pass: PASSWORD,
    },
});

export async function sendMail({
    sendTo,
    subject,
    text,
    html,
}: {
    sendTo?: string;
    subject: string;
    text: string;
    html?: string;
}) {
    // Validate required credentials
    if (!USERNAME || !PASSWORD) {
        console.error('Missing Mailtrap credentials. Check EMAIL_USER and EMAIL_PASSWORD environment variables.');
        return null;
    }

    const recipient = sendTo;

    if (!recipient) {
        console.error('No recipient specified for email');
        return null;
    }

    try {
        await transporter.verify();
    } catch (error: any) {
        console.error('❌ Mailtrap SMTP connection failed:', error.message);
        console.error('Please check your Mailtrap credentials in environment variables');
        return null;
    }

    try {
        const info = await transporter.sendMail({
            from: EMAIL_FROM,
            to: recipient,
            subject: subject,
            text: text,
            html: html || text,
        });

        return info;
    } catch (error: any) {
        console.error('❌ Email sending failed via Mailtrap:', error.message);
        return null;
    }
}