export interface BidFormData {
  price: string;
  days: string;
  description: string;
}

export interface BidModalProps {
  isOpen: boolean;
  onClose: () => void;
  onSubmit: (bidData: BidFormData) => Promise<void>;
  projectTitle?: string;
  projectId?: string;
  loading?: boolean;
  isUpdateMode?: boolean;
  projectProposal?:any;
  initialBidData?: {
    amount: string;
    deliveryTime: string;
    proposal: string;
  };
  projectBudget?: number;
  projectDuration?: number
}

export interface SubmittedBid {
  id: string;
  projectId: string;
  freelancerId: string;
  price: number;
  days: number;
  description: string;
  status: 'PENDING' | 'ACCEPTED' | 'REJECTED';
  createdAt: string;
  updatedAt: string;
}

export interface BidWithFreelancer {
  id: string;
  projectId: string;
  freelancerId: string;
  amount: number;
  duration: number;
  proposal: string;
  status: 'PENDING' | 'ACCEPTED' | 'REJECTED' | 'WITHDRAWN';
  createdAt: string;
  updatedAt: string;
  freelancer: {
    id: string;
    email: string;
    image: string | null;
    profile: {
      firstName: string | null;
      lastName: string | null;
      phone: string | null;
      city: string | null;
      country: {
        name: string;
      };
    } | null;
    _count: {
      receivedReviews: number;
    };
    averageRating: number;
  };
}

export interface ProjectBidsResponse {
  success: boolean;
  data: {
    projectId: string;
    projectTitle: string;
    bids: BidWithFreelancer[];
    totalBids: number;
  };
  error?: string;
}

export interface BidFilters {
  search?: string;
  location?: string;
  rating?: string;
  sortBy?: 'newest' | 'oldest' | 'price_low' | 'price_high' | 'rating';
}