
const WebSocket = require('ws');

const wsUrl = 'ws://localhost:3005/api/websocket';
console.log(`Connecting to ${wsUrl}`);

const ws = new WebSocket(wsUrl);

ws.on('open', function open() {
  console.log('Connected!');
  const message = { type: 'ping' };
  ws.send(JSON.stringify(message));
  console.log('Sent:', message);
});

ws.on('message', function incoming(data) {
  console.log('Received:', data.toString());
  const message = JSON.parse(data.toString());
  if (message.type === 'pong') {
    console.log('Test successful!');
    ws.close();
  }
});

ws.on('close', function close() {
  console.log('Disconnected');
});

ws.on('error', function error(err) {
  console.error('Error:', err.message);
});
